/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.client;

public class ElasticsearchClientException
extends Exception {
    private static final long serialVersionUID = 8572343147542928247L;
    private String method = "";
    private int statusCode = -1;
    private String responseContent = "";

    public ElasticsearchClientException(String message) {
        super(message);
    }

    public ElasticsearchClientException(String method, int statusCode, String responseContent) {
        super(String.format("%s failed with HTTP status code %d; content: %s", method, statusCode, responseContent));
        this.method = method;
        this.statusCode = statusCode;
        this.responseContent = responseContent;
    }

    public ElasticsearchClientException(Throwable cause) {
        super(cause);
    }

    public String getMethod() {
        return this.method;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseContent() {
        return this.responseContent;
    }
}

