/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.client;

import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClient;
import com.github.alexcojocaru.mojo.elasticsearch.v2.client.ElasticsearchClientException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.awaitility.Awaitility;
import org.mockito.Mockito;

public class Monitor {
    private final ElasticsearchClient client;
    private final Log log;

    public Monitor(ElasticsearchClient client, Log log) {
        this.client = client;
        this.log = log;
    }

    public void waitToStartInstance(final String baseDir, final String clusterName, int timeout) {
        this.log.debug((CharSequence)String.format("Waiting  up to %ds for the Elasticsearch instance to start ...", timeout));
        Awaitility.await().atMost((long)timeout, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Monitor.isProcessRunning(baseDir) && Monitor.this.isInstanceRunning(clusterName);
            }
        });
        this.log.info((CharSequence)"The Elasticsearch instance has started");
    }

    public static boolean isProcessRunning(String baseDir) {
        File pidFile = new File(baseDir, "pid");
        boolean exists = pidFile.isFile();
        return exists;
    }

    public boolean isInstanceRunning(String clusterName) {
        boolean result;
        try {
            Map response = this.client.get("/", Map.class);
            result = clusterName.equals(response.get("cluster_name"));
        }
        catch (ElasticsearchClientException e) {
            result = false;
        }
        return result;
    }

    public static boolean isInstanceRunning(String clusterName, int httpPort) {
        Log log = (Log)Mockito.mock(Log.class);
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withLog(log).withHostname("localhost").withPort(httpPort).withSocketTimeout(5000).build();){
            boolean bl = new Monitor(client, log).isInstanceRunning(clusterName);
            return bl;
        }
    }

    public void waitToStartCluster(final String clusterName, final int nodesCount, int timeout) {
        this.log.debug((CharSequence)String.format("Waiting  up to %ds for the Elasticsearch cluster to start ...", timeout));
        Awaitility.await().atMost((long)timeout, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Monitor.isClusterRunning(clusterName, nodesCount, Monitor.this.client);
            }
        });
        this.log.info((CharSequence)"The Elasticsearch cluster has started");
    }

    public static boolean isClusterRunning(String clusterName, int instanceCount, ElasticsearchClient client) {
        boolean result;
        try {
            Map response = client.get("/_nodes", Map.class);
            result = clusterName.equals(response.get("cluster_name"));
            Map nodesInfo = (Map)response.get("_nodes");
            result &= instanceCount == (Integer)nodesInfo.get("successful");
        }
        catch (ElasticsearchClientException e) {
            result = false;
        }
        return result;
    }

    public static boolean isClusterRunning(String clusterName, int instanceCount, int httpPort) {
        Log log = (Log)Mockito.mock(Log.class);
        try (ElasticsearchClient client = new ElasticsearchClient.Builder().withLog(log).withHostname("localhost").withPort(httpPort).withSocketTimeout(5000).build();){
            boolean bl = Monitor.isClusterRunning(clusterName, instanceCount, client);
            return bl;
        }
    }
}

