/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.InstanceStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.FilesystemUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.ProcessUtil;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class RemovePluginsStep
implements InstanceStep {
    @Override
    public void execute(InstanceConfiguration config) {
        Log log = config.getClusterConfiguration().getLog();
        File pluginsDir = new File(config.getBaseDir(), "plugins");
        try {
            log.debug((CharSequence)String.format("Checking if the plugins directory with path: '%s' exists", pluginsDir.getCanonicalPath()));
        }
        catch (IOException e) {
            throw new ElasticsearchSetupException("Cannot check if the plugins directory exists", e);
        }
        if (pluginsDir.exists()) {
            log.debug((CharSequence)"The plugins directory exists; removing all installed plugins");
            if (VersionUtil.isEqualOrGreater_6_4_0(config.getClusterConfiguration().getVersion())) {
                FilesystemUtil.setScriptPermission(config, "elasticsearch-cli");
            }
            FilesystemUtil.setScriptPermission(config, "elasticsearch-plugin");
            CommandLine cmd = ProcessUtil.buildCommandLine("bin/elasticsearch-plugin").addArgument("list");
            List<String> output = ProcessUtil.executeScript(config, cmd);
            List pluginNames = output.stream().map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toCollection(ArrayList::new));
            for (String pluginName : pluginNames) {
                log.info((CharSequence)String.format("Removing plugin '%s'", pluginName));
                CommandLine removeCmd = ProcessUtil.buildCommandLine("bin/elasticsearch-plugin").addArgument("remove").addArgument(pluginName);
                ProcessUtil.executeScript(config, removeCmd);
            }
        } else {
            log.debug((CharSequence)"The plugins directory does not exist");
        }
    }
}

