/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValidatePortsStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        ArrayList ports = new ArrayList();
        config.getInstanceConfigurationList().forEach(instanceConfig -> ports.add(instanceConfig.getHttpPort()));
        config.getInstanceConfigurationList().forEach(instanceConfig -> ports.add(instanceConfig.getTransportPort()));
        List protectedPorts = ports.stream().filter(port -> port < 1024).collect(Collectors.toList());
        if (protectedPorts.size() > 0) {
            throw new ElasticsearchSetupException(String.format("The following provided or inferred ports are protected (below 1024): %s", StringUtils.join(protectedPorts, (char)',')));
        }
    }
}

