/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.step;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.ClusterStep;
import com.github.alexcojocaru.mojo.elasticsearch.v2.util.VersionUtil;
import org.apache.commons.lang3.StringUtils;

public class ValidateVersionStep
implements ClusterStep {
    @Override
    public void execute(ClusterConfiguration config) {
        String version = config.getVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new ElasticsearchSetupException(String.format("Please provide a valid Elasticsearch version.", new Object[0]));
        }
        if (VersionUtil.isUnder_5_0_0(version)) {
            throw new ElasticsearchSetupException(String.format("elasticsearch-maven-plugin supports only versions 5+ of Elasticsearch. You configured: %s.", version));
        }
    }
}

