/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2.util;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ElasticsearchSetupException;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.logging.Log;

public class ProcessUtil {
    public static CommandLine buildCommandLine(String executable) {
        CommandLine cmd;
        if (SystemUtils.IS_OS_WINDOWS) {
            String windowsExecutable = executable.replace('/', '\\');
            cmd = new CommandLine("cmd").addArgument("/c").addArgument(windowsExecutable);
        } else {
            cmd = new CommandLine(executable);
        }
        return cmd;
    }

    public static CommandLine buildKillCommandLine(String pid) {
        CommandLine command = SystemUtils.IS_OS_WINDOWS ? new CommandLine("taskkill").addArgument("/F").addArgument("/pid").addArgument(pid) : new CommandLine("kill").addArgument(pid);
        return command;
    }

    public static void cleanupPid(String baseDir) {
        if (SystemUtils.IS_OS_WINDOWS) {
            new File(baseDir, "pid").delete();
        }
    }

    public static String getElasticsearchPid(String baseDir) {
        try {
            String pid = new String(Files.readAllBytes(Paths.get(baseDir, "pid")));
            return pid;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot read the PID of the Elasticsearch process from the pid file in directory '%s'", baseDir), e);
        }
    }

    public static boolean isWindowsProcessAlive(InstanceConfiguration config, String pid) {
        CommandLine command = new CommandLine("tasklist").addArgument("/FI").addArgument("PID eq " + pid, true);
        List<String> output = ProcessUtil.executeScript(config, command, true);
        String keyword = String.format(" %s ", pid);
        boolean isRunning = output.stream().anyMatch(s -> s.contains(keyword));
        return isRunning;
    }

    public static List<String> executeScript(InstanceConfiguration config, CommandLine command) {
        return ProcessUtil.executeScript(config, command, null, null, false);
    }

    public static List<String> executeScript(InstanceConfiguration config, CommandLine command, boolean disableLogging) {
        return ProcessUtil.executeScript(config, command, null, null, disableLogging);
    }

    public static List<String> executeScript(InstanceConfiguration config, CommandLine command, Map<String, String> environment, ProcessDestroyer processDestroyer) {
        return ProcessUtil.executeScript(config, command, environment, processDestroyer, false);
    }

    public static List<String> executeScript(InstanceConfiguration config, CommandLine command, Map<String, String> environment, ProcessDestroyer processDestroyer, boolean disableLogging) {
        Log log = config.getClusterConfiguration().getLog();
        int instanceId = config.getId();
        File baseDir = new File(config.getBaseDir());
        Map<String, String> completeEnvironment = ProcessUtil.createEnvironment(environment);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(baseDir);
        executor.setProcessDestroyer(processDestroyer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)(disableLogging ? outputStream : new TeeOutputStream((OutputStream)System.out, (OutputStream)outputStream)), (OutputStream)(disableLogging ? errorStream : new TeeOutputStream((OutputStream)System.err, (OutputStream)errorStream))));
        try {
            log.debug((CharSequence)String.format("Using environment: %s", completeEnvironment));
            String commandMessage = String.format("Elasticsearch[%d]: Executing command '%s' in directory '%s'", instanceId, command.toString(), baseDir);
            if (disableLogging) {
                log.debug((CharSequence)commandMessage);
            } else {
                log.info((CharSequence)commandMessage);
            }
            int exitCode = executor.execute(command, completeEnvironment);
            if (exitCode != 0) {
                throw new ElasticsearchSetupException(String.format("Elasticsearch [%d]: Command '%s' in directory '%s' finished with exit code %d; see above for details", instanceId, command, baseDir, exitCode));
            }
            String resultMessage = String.format("Elasticsearch[%d]: The process finished with exit code %d", instanceId, exitCode);
            if (disableLogging) {
                log.debug((CharSequence)resultMessage);
            } else {
                log.info((CharSequence)resultMessage);
            }
        }
        catch (IOException e) {
            List<String> output = ProcessUtil.readBuffer(outputStream);
            List<String> error = ProcessUtil.readBuffer(errorStream);
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder();
            message.append("Elasticsearch [");
            message.append(instanceId);
            message.append("]: Cannot execute command '");
            message.append(command);
            message.append("' in directory '");
            message.append(baseDir);
            message.append("'");
            message.append(lineSeparator);
            message.append("Output:");
            message.append(lineSeparator);
            message.append(StringUtils.join(output, (String)lineSeparator));
            message.append(lineSeparator);
            message.append("Error:");
            message.append(lineSeparator);
            message.append(StringUtils.join(error, (String)lineSeparator));
            throw new ElasticsearchSetupException(message.toString(), e);
        }
        return ProcessUtil.readBuffer(outputStream);
    }

    private static List<String> readBuffer(ByteArrayOutputStream outputStream) {
        ArrayList<String> outputLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(outputStream.toString()));){
            String line;
            while ((line = reader.readLine()) != null) {
                outputLines.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.unmodifiableList(outputLines);
    }

    public static Map<String, String> createEnvironment(Map<String, String> environment) {
        Map result = null;
        try {
            result = EnvironmentUtils.getProcEnvironment();
        }
        catch (IOException ex) {
            throw new ElasticsearchSetupException("Cannot get the current process environment", ex);
        }
        result.remove("JAVA_TOOL_OPTIONS");
        result.remove("JAVA_OPTS");
        result.remove("ES_HOME");
        result.remove("ES_JAVA_OPTS");
        result.remove("ES_PATH_CONF");
        result.remove("ES_TMPDIR");
        if (environment != null) {
            result.putAll(environment);
        }
        return result;
    }
}

