/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.senseai;

import com.almasb.fxgl.ai.senseai.SenseAIState;
import com.almasb.fxgl.entity.component.Component;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0014\u00100\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010 0 0'R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\u0004R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0004R\"\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\u0004R$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010 0 0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/almasb/fxgl/ai/senseai/HearingSenseComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "hearingRadius", "", "(D)V", "aggressiveStateThreshold", "getAggressiveStateThreshold", "()D", "setAggressiveStateThreshold", "alertStateThreshold", "getAlertStateThreshold", "setAlertStateThreshold", "alertness", "alertnessDecay", "getAlertnessDecay", "setAlertnessDecay", "calmFactor", "getCalmFactor", "setCalmFactor", "getHearingRadius", "setHearingRadius", "lastHeardPoint", "Ljavafx/geometry/Point2D;", "kotlin.jvm.PlatformType", "getLastHeardPoint", "()Ljavafx/geometry/Point2D;", "setLastHeardPoint", "(Ljavafx/geometry/Point2D;)V", "noiseVolumeTolerance", "getNoiseVolumeTolerance", "setNoiseVolumeTolerance", "value", "Lcom/almasb/fxgl/ai/senseai/SenseAIState;", "state", "getState", "()Lcom/almasb/fxgl/ai/senseai/SenseAIState;", "setState", "(Lcom/almasb/fxgl/ai/senseai/SenseAIState;)V", "stateProp", "Ljavafx/beans/property/SimpleObjectProperty;", "alertThreshold", "decayAmount", "hearNoise", "", "point", "volume", "onUpdate", "tpf", "stateProperty", "fxgl-entity"})
public final class HearingSenseComponent
extends Component {
    private double hearingRadius;
    private double alertness;
    private double alertnessDecay;
    private double noiseVolumeTolerance;
    private double calmFactor;
    private double alertStateThreshold;
    private double aggressiveStateThreshold;
    private Point2D lastHeardPoint;
    @NotNull
    private final SimpleObjectProperty<SenseAIState> stateProp;

    public HearingSenseComponent(double hearingRadius) {
        this.hearingRadius = hearingRadius;
        this.alertnessDecay = 0.1;
        this.calmFactor = 0.5;
        this.alertStateThreshold = 0.5;
        this.aggressiveStateThreshold = 0.75;
        this.lastHeardPoint = Point2D.ZERO;
        this.stateProp = new SimpleObjectProperty((Object)SenseAIState.CALM);
    }

    public final double getHearingRadius() {
        return this.hearingRadius;
    }

    public final void setHearingRadius(double d) {
        this.hearingRadius = d;
    }

    public final double getAlertnessDecay() {
        return this.alertnessDecay;
    }

    public final void setAlertnessDecay(double d) {
        this.alertnessDecay = d;
    }

    public final double getNoiseVolumeTolerance() {
        return this.noiseVolumeTolerance;
    }

    public final void setNoiseVolumeTolerance(double d) {
        this.noiseVolumeTolerance = d;
    }

    public final double getCalmFactor() {
        return this.calmFactor;
    }

    public final void setCalmFactor(double d) {
        this.calmFactor = d;
    }

    public final double getAlertStateThreshold() {
        return this.alertStateThreshold;
    }

    public final void setAlertStateThreshold(double d) {
        this.alertStateThreshold = d;
    }

    public final double getAggressiveStateThreshold() {
        return this.aggressiveStateThreshold;
    }

    public final void setAggressiveStateThreshold(double d) {
        this.aggressiveStateThreshold = d;
    }

    public final Point2D getLastHeardPoint() {
        return this.lastHeardPoint;
    }

    public final void setLastHeardPoint(Point2D point2D) {
        this.lastHeardPoint = point2D;
    }

    @NotNull
    public final SenseAIState getState() {
        Object object = this.stateProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stateProp.value");
        return (SenseAIState)((Object)object);
    }

    public final void setState(@NotNull SenseAIState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.stateProp.setValue((Object)value);
    }

    @NotNull
    public final SimpleObjectProperty<SenseAIState> stateProperty() {
        return this.stateProp;
    }

    @Override
    public void onUpdate(double tpf) {
        double d = 0.0;
        double d2 = this.alertness - this.alertnessDecay * tpf;
        boolean bl = false;
        this.alertness = Math.max(d, d2);
        if (this.alertness >= this.aggressiveStateThreshold) {
            this.setState(SenseAIState.AGGRESSIVE);
        } else if (this.alertness >= this.alertStateThreshold) {
            this.setState(SenseAIState.ALERT);
        } else {
            this.setState(SenseAIState.CALM);
        }
    }

    public final void hearNoise(@NotNull Point2D point, double volume) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.getState() == SenseAIState.CANNOT_BE_DISTURBED) {
            return;
        }
        if (volume <= this.noiseVolumeTolerance) {
            return;
        }
        double distance = this.entity.getPosition().distance(point);
        if (distance > this.hearingRadius) {
            return;
        }
        this.lastHeardPoint = point;
        double stateVolumeRatio = this.getState() == SenseAIState.CALM ? this.calmFactor : 1.0;
        double adjustedVolume = volume * (1.0 - distance / this.hearingRadius) * stateVolumeRatio;
        HearingSenseComponent hearingSenseComponent = this;
        hearingSenseComponent.alertness += adjustedVolume;
    }

    @NotNull
    public final HearingSenseComponent alertnessDecay(double decayAmount) {
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$alertnessDecay_u24lambda_u2d0 = hearingSenseComponent;
        boolean bl3 = false;
        $this$alertnessDecay_u24lambda_u2d0.setAlertnessDecay(decayAmount);
        return hearingSenseComponent;
    }

    @NotNull
    public final HearingSenseComponent noiseVolumeTolerance(double noiseVolumeTolerance) {
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$noiseVolumeTolerance_u24lambda_u2d1 = hearingSenseComponent;
        boolean bl3 = false;
        $this$noiseVolumeTolerance_u24lambda_u2d1.setNoiseVolumeTolerance(noiseVolumeTolerance);
        return hearingSenseComponent;
    }

    @NotNull
    public final HearingSenseComponent calmFactor(double calmFactor) {
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$calmFactor_u24lambda_u2d2 = hearingSenseComponent;
        boolean bl3 = false;
        $this$calmFactor_u24lambda_u2d2.setCalmFactor(calmFactor);
        return hearingSenseComponent;
    }

    @NotNull
    public final HearingSenseComponent alertStateThreshold(double alertThreshold) {
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$alertStateThreshold_u24lambda_u2d3 = hearingSenseComponent;
        boolean bl3 = false;
        $this$alertStateThreshold_u24lambda_u2d3.setAlertStateThreshold(alertThreshold);
        return hearingSenseComponent;
    }

    @NotNull
    public final HearingSenseComponent aggressiveStateThreshold(double aggressiveStateThreshold) {
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$aggressiveStateThreshold_u24lambda_u2d4 = hearingSenseComponent;
        boolean bl3 = false;
        $this$aggressiveStateThreshold_u24lambda_u2d4.setAggressiveStateThreshold(aggressiveStateThreshold);
        return hearingSenseComponent;
    }

    @NotNull
    public final HearingSenseComponent lastHeardPoint(@NotNull Point2D lastHeardPoint) {
        Intrinsics.checkNotNullParameter((Object)lastHeardPoint, (String)"lastHeardPoint");
        HearingSenseComponent hearingSenseComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        HearingSenseComponent $this$lastHeardPoint_u24lambda_u2d5 = hearingSenseComponent;
        boolean bl3 = false;
        $this$lastHeardPoint_u24lambda_u2d5.setLastHeardPoint(lastHeardPoint);
        return hearingSenseComponent;
    }
}

