/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.components.IDComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.entity.level.LevelLoadingException;
import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.TMXLevelLoaderKt;
import com.almasb.fxgl.entity.level.tiled.TextData;
import com.almasb.fxgl.entity.level.tiled.Tile;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.TiledObject;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.entity.level.tiled.TilesetLoader;
import com.almasb.fxgl.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javafx.scene.shape.Polygon;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TMXLevelLoader;", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "createObjectLayerEntities", "", "Lcom/almasb/fxgl/entity/Entity;", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "tilesetLoader", "Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "world", "Lcom/almasb/fxgl/entity/GameWorld;", "createTileLayerEntities", "load", "Lcom/almasb/fxgl/entity/level/Level;", "url", "Ljava/net/URL;", "parse", "inputStream", "Ljava/io/InputStream;", "parseData", "", "layer", "Lcom/almasb/fxgl/entity/level/tiled/Layer;", "data", "", "start", "Ljavax/xml/stream/events/StartElement;", "parseImage", "tile", "Lcom/almasb/fxgl/entity/level/tiled/Tile;", "tileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "parseMap", "parseMapProperty", "parseObject", "obj", "Lcom/almasb/fxgl/entity/level/tiled/TiledObject;", "parseObjectGroupLayer", "parseObjectPolygon", "parseObjectProperty", "parseTextProperty", "parseTile", "parseTileLayer", "parseTileset", "fxgl-entity"})
public final class TMXLevelLoader
implements LevelLoader {
    @NotNull
    private final Logger log;

    public TMXLevelLoader() {
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(TMXLevelLoader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Level load(@NotNull URL url, @NotNull GameWorld world) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        try {
            Closeable closeable = url.openStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                it = this.parse((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object map = it;
            this.log.debug(Intrinsics.stringPlus((String)"Parsed TiledMap: ", (Object)url));
            TilesetLoader tilesetLoader = new TilesetLoader((TiledMap)map, url);
            List<Entity> tileLayerEntities = this.createTileLayerEntities((TiledMap)map, tilesetLoader);
            List<Entity> objectEntities = this.createObjectLayerEntities((TiledMap)map, tilesetLoader, world);
            Level level = new Level(((TiledMap)map).getWidth() * ((TiledMap)map).getTilewidth(), ((TiledMap)map).getHeight() * ((TiledMap)map).getTileheight(), CollectionsKt.plus((Collection)tileLayerEntities, (Iterable)objectEntities));
            ((TiledMap)map).getProperties().forEach((arg_0, arg_1) -> TMXLevelLoader.load$lambda-1(level, arg_0, arg_1));
            return level;
        }
        catch (Exception e) {
            this.log.warning("Parse error", (Throwable)e);
            e.printStackTrace();
            throw new LevelLoadingException(String.valueOf(e.getMessage()), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createTileLayerEntities(TiledMap map, TilesetLoader tilesetLoader) {
        void $this$mapTo$iv$iv;
        Layer it;
        Iterable $this$filterTo$iv$iv;
        this.log.debug("Creating tile layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"tilelayer")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ViewComponent viewComponent;
            void layer;
            it = (Layer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entity entity = new Entity();
            boolean bl2 = false;
            boolean bl3 = false;
            Entity it2 = entity;
            boolean bl4 = false;
            it2.setType((Serializable)((Object)"TiledMapLayer"));
            it2.setProperty("layer", layer);
            String string = map.getOrientation();
            if (Intrinsics.areEqual((Object)string, (Object)"orthogonal")) {
                viewComponent = it2.getViewComponent();
                Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"it.viewComponent");
                ViewComponent.addChild$default(viewComponent, tilesetLoader.loadView(layer.getName()), false, 2, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"hexagonal")) {
                viewComponent = it2.getViewComponent();
                Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"it.viewComponent");
                ViewComponent.addChild$default(viewComponent, tilesetLoader.loadViewHex(layer.getName()), false, 2, null);
            } else {
                this.log.warning(Intrinsics.stringPlus((String)"Unknown map orientation: ", (Object)map.getOrientation()));
            }
            Entity entity2 = entity;
            collection.add(entity2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createObjectLayerEntities(TiledMap map, TilesetLoader tilesetLoader, GameWorld world) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Layer it;
        void $this$filterTo$iv$iv;
        this.log.debug("Creating object layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"objectgroup")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Layer)element$iv$iv;
            bl = false;
            list$iv$iv = it.getObjects();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl2;
            void tiledObject;
            list$iv$iv = (TiledObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl22 = false;
            SpawnData data = new SpawnData(tiledObject.getX(), tiledObject.getY() - (tiledObject.getGid() == 0 ? 0 : tiledObject.getHeight()), 0.0, 4, null);
            Object object = data;
            boolean bl3 = false;
            boolean bl4 = false;
            SpawnData $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9 = object;
            boolean bl5 = false;
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("name", tiledObject.getName());
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("type", tiledObject.getType());
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("width", tiledObject.getWidth());
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("height", tiledObject.getHeight());
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("rotation", Float.valueOf(tiledObject.getRotation()));
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("id", tiledObject.getId());
            $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("gid", tiledObject.getGid());
            Object object2 = tiledObject.getTextData();
            if (object2 != null) {
                TextData textData = object2;
                boolean bl6 = false;
                bl2 = false;
                TextData it3 = textData;
                boolean bl7 = false;
                $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("text", it3.getText());
                $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put("color", it3.getColor());
            }
            Map $this$forEach$iv = tiledObject.getProperties();
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            bl2 = false;
            Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry;
                Map.Entry<String, Object> it2 = entry = iterator.next();
                boolean bl8 = false;
                $this$createObjectLayerEntities_u24lambda_u2d12_u24lambda_u2d9.put(it2.getKey(), it2.getValue());
            }
            object = world.create(tiledObject.getType(), data);
            bl3 = false;
            bl4 = false;
            Object e = object;
            boolean bl9 = false;
            $this$forEach$iv = data.getData();
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl2 = false;
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry;
                Map.Entry<String, Object> it2 = entry = iterator.next();
                boolean bl10 = false;
                ((Entity)e).setProperty(it2.getKey(), it2.getValue());
            }
            ((Entity)e).addComponent(new IDComponent(tiledObject.getName(), tiledObject.getId()));
            ((Entity)e).setPosition(data.getX(), data.getY());
            ((Entity)e).setRotation(tiledObject.getRotation());
            if (tiledObject.getGid() != 0) {
                object2 = ((Entity)e).getViewComponent();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.viewComponent");
                ViewComponent.addChild$default((ViewComponent)object2, tilesetLoader.loadView(tiledObject.getGid(), tiledObject.isFlippedHorizontal(), tiledObject.isFlippedVertical()), false, 2, null);
            }
            Object object3 = object;
            collection.add(object3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TiledMap parse(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream, "UTF-8");
        TiledMap map = new TiledMap(0, 0, 0, 0, null, null, null, null, null, 0, 0, null, null, false, 0, null, null, null, null, 524287, null);
        boolean bl = false;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        boolean bl2 = false;
        ArrayList<Tileset> tilesets = new ArrayList<Tileset>();
        Layer currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
        Tileset currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, null, 8191, null);
        Tile currentTile = new Tile(0, null, 0, 0, null, 31, null);
        TiledObject currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, null, Short.MAX_VALUE, null);
        boolean insideTileTag = false;
        boolean mapPropertiesFinished = false;
        while (eventReader.hasNext()) {
            EndElement endElement;
            int n;
            String string;
            XMLEvent event;
            block55: {
                StartElement start;
                event = eventReader.nextEvent();
                if (!event.isStartElement() || (string = (start = event.asStartElement()).getName().getLocalPart()) == null) break block55;
                n = -1;
                switch (string.hashCode()) {
                    case 100313435: {
                        if (string.equals("image")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3076010: {
                        if (string.equals("data")) {
                            n = 2;
                        }
                        break;
                    }
                    case -397519558: {
                        if (string.equals("polygon")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1314831628: {
                        if (string.equals("tileset")) {
                            n = 4;
                        }
                        break;
                    }
                    case 3560110: {
                        if (string.equals("tile")) {
                            n = 5;
                        }
                        break;
                    }
                    case -993141291: {
                        if (string.equals("property")) {
                            n = 6;
                        }
                        break;
                    }
                    case 3556653: {
                        if (string.equals("text")) {
                            n = 7;
                        }
                        break;
                    }
                    case 107868: {
                        if (string.equals("map")) {
                            n = 8;
                        }
                        break;
                    }
                    case 102749521: {
                        if (string.equals("layer")) {
                            n = 9;
                        }
                        break;
                    }
                    case -1269857632: {
                        if (string.equals("objectgroup")) {
                            n = 10;
                        }
                        break;
                    }
                    case -1023368385: {
                        if (string.equals("object")) {
                            n = 11;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseMap(map, start);
                        break;
                    }
                    case 4: {
                        currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, null, 8191, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTileset(currentTileset, start);
                        break;
                    }
                    case 5: {
                        currentTile = new Tile(0, null, 0, 0, null, 31, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTile(currentTile, start);
                        insideTileTag = true;
                        break;
                    }
                    case 1: {
                        if (insideTileTag) {
                            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                            this.parseImage(currentTile, start);
                            break;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseImage(currentTileset, start);
                        break;
                    }
                    case 9: {
                        currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTileLayer(currentLayer, start);
                        break;
                    }
                    case 2: {
                        String string2 = eventReader.getElementText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventReader.elementText");
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseData(currentLayer, string2, start);
                        break;
                    }
                    case 10: {
                        currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObjectGroupLayer(currentLayer, start);
                        break;
                    }
                    case 11: {
                        mapPropertiesFinished = true;
                        currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, null, Short.MAX_VALUE, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObject(currentLayer, currentObject, start);
                        break;
                    }
                    case 6: {
                        if (mapPropertiesFinished) {
                            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                            this.parseObjectProperty(currentObject, start);
                            break;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseMapProperty(map, start);
                        break;
                    }
                    case 7: {
                        String string2 = eventReader.getElementText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventReader.elementText");
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTextProperty(currentObject, string2, start);
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObjectPolygon(currentObject, start);
                    }
                }
            }
            if (!event.isEndElement() || (string = (endElement = event.asEndElement()).getName().getLocalPart()) == null) continue;
            tmp = -1;
            switch (string.hashCode()) {
                case -1314831628: {
                    if (string.equals("tileset")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3560110: {
                    if (string.equals("tile")) {
                        tmp = 2;
                    }
                    break;
                }
                case 102749521: {
                    if (string.equals("layer")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1269857632: {
                    if (string.equals("objectgroup")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    tilesets.add(currentTileset);
                    break;
                }
                case 2: {
                    currentTileset.getTiles().add(currentTile);
                    insideTileTag = false;
                    break;
                }
                case 3: {
                    layers.add(currentLayer);
                }
            }
        }
        map.setLayers((List<Layer>)layers);
        map.setTilesets((List<Tileset>)tilesets);
        return map;
    }

    private final void parseMap(TiledMap map, StartElement start) {
        map.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        map.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        map.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        map.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        map.setNextobjectid(TMXLevelLoaderKt.access$getInt(start, "nextobjectid"));
        map.setType("map");
        map.setVersion(1);
        map.setInfinite(TMXLevelLoaderKt.access$getInt(start, "infinite") == 1);
        map.setBackgroundcolor(TMXLevelLoaderKt.access$getString(start, "backgroundcolor"));
        map.setOrientation(TMXLevelLoaderKt.access$getString(start, "orientation"));
        map.setHexsidelength(TMXLevelLoaderKt.access$getInt(start, "hexsidelength"));
        map.setStaggeraxis(TMXLevelLoaderKt.access$getString(start, "staggeraxis"));
        map.setStaggerindex(TMXLevelLoaderKt.access$getString(start, "staggerindex"));
        map.setRenderorder(TMXLevelLoaderKt.access$getString(start, "renderorder"));
        map.setTiledversion(TMXLevelLoaderKt.access$getString(start, "tiledversion"));
        if (!Intrinsics.areEqual((Object)map.getTiledversion(), (Object)"1.2.3")) {
            this.log.warning("TiledMap generated from " + map.getTiledversion() + ". Supported version: 1.2.3. Some features may not be parsed fully.");
        }
    }

    private final void parseTileset(Tileset tileset, StartElement start) {
        tileset.setFirstgid(TMXLevelLoaderKt.access$getInt(start, "firstgid"));
        tileset.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        tileset.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        tileset.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        tileset.setMargin(TMXLevelLoaderKt.access$getInt(start, "margin"));
        tileset.setSpacing(TMXLevelLoaderKt.access$getInt(start, "spacing"));
        tileset.setTilecount(TMXLevelLoaderKt.access$getInt(start, "tilecount"));
        tileset.setColumns(TMXLevelLoaderKt.access$getInt(start, "columns"));
    }

    private final void parseTile(Tile tile, StartElement start) {
        tile.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
    }

    private final void parseImage(Tileset tileset, StartElement start) {
        tileset.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tileset.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tileset.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tileset.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseImage(Tile tile, StartElement start) {
        tile.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tile.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tile.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tile.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseTileLayer(Layer layer, StartElement start) {
        layer.setType("tilelayer");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        layer.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        layer.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        layer.setOpacity(TMXLevelLoaderKt.access$getFloat(start, "opacity"));
        layer.setVisible(TMXLevelLoaderKt.access$getInt(start, "visible") == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseData(Layer layer, String data, StartElement start) {
        String string = TMXLevelLoaderKt.access$getString(start, "encoding");
        if (Intrinsics.areEqual((Object)string, (Object)"csv")) {
            Collection<Long> collection;
            void $this$mapTo$iv$iv22;
            void $this$map$iv;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)data, (String)"\n", (String)"", (boolean)false, (int)4, null), (String[])object, (boolean)false, (int)0, (int)6, null);
            Layer layer2 = layer;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it;
                boolean bl2 = false;
                void v0 = string3;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                bl2 = false;
                Long l = Long.parseLong(string3);
                collection.add(l);
            }
            collection = (List)destination$iv$iv;
            layer2.setData((List<Long>)collection);
        } else if (Intrinsics.areEqual((Object)string, (Object)"base64")) {
            InputStream inputStream;
            boolean bl;
            byte[] byArray;
            String $i$f$map = data;
            boolean $this$mapTo$iv$iv22 = false;
            String string4 = $i$f$map;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            byte[] bytes = Base64.getDecoder().decode(((Object)StringsKt.trim((CharSequence)string4)).toString());
            String $this$mapTo$iv$iv22 = TMXLevelLoaderKt.access$getString(start, "compression");
            if (Intrinsics.areEqual((Object)$this$mapTo$iv$iv22, (Object)"zlib")) {
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                byArray = bytes;
                bl = false;
                inputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
            } else if (Intrinsics.areEqual((Object)$this$mapTo$iv$iv22, (Object)"gzip")) {
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                byArray = bytes;
                bl = false;
                inputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            } else {
                this.log.warning("Unsupported base64 compression: '" + TMXLevelLoaderKt.access$getString(start, "compression") + "'. " + layer.getName() + " may fail to render.");
                inputStream = InputStream.nullInputStream();
            }
            InputStream inputStream2 = inputStream;
            boolean bl3 = false;
            ArrayList<Long> longArray = new ArrayList<Long>();
            Closeable closeable = inputStream2;
            bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl5 = false;
                while (it.available() > 0) {
                    byte[] rawInt = it.readNBytes(4);
                    long value = ((long)rawInt[0] & 0xFFL) << 0 | ((long)rawInt[1] & 0xFFL) << 8 | ((long)rawInt[2] & 0xFFL) << 16 | ((long)rawInt[3] & 0xFFL) << 24;
                    longArray.add(value);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            layer.setData((List<Long>)longArray);
        }
    }

    private final void parseObjectGroupLayer(Layer layer, StartElement start) {
        layer.setType("objectgroup");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
    }

    private final void parseObject(Layer layer, TiledObject obj, StartElement start) {
        obj.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        obj.setType(TMXLevelLoaderKt.access$getString(start, "type"));
        obj.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
        obj.setX(TMXLevelLoaderKt.access$getInt(start, "x"));
        obj.setY(TMXLevelLoaderKt.access$getInt(start, "y"));
        obj.setRotation(TMXLevelLoaderKt.access$getFloat(start, "rotation"));
        obj.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        obj.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        int gidUInt = TMXLevelLoaderKt.access$getUInt(start, "gid");
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        int FLIPPED_HORIZONTALLY_FLAG = UInt.constructor-impl((int)n);
        n2 = 0x40000000;
        int n3 = 0;
        int FLIPPED_VERTICALLY_FLAG = UInt.constructor-impl((int)n2);
        n3 = 0x20000000;
        int n4 = 0;
        int FLIPPED_DIAGONALLY_FLAG = UInt.constructor-impl((int)n3);
        n3 = 0;
        n3 = 0;
        n4 = 0;
        obj.setFlippedHorizontal(UInt.constructor-impl((int)(gidUInt & FLIPPED_HORIZONTALLY_FLAG)) != UInt.constructor-impl((int)n3));
        n3 = 0;
        n3 = 0;
        n4 = 0;
        obj.setFlippedVertical(UInt.constructor-impl((int)(gidUInt & FLIPPED_VERTICALLY_FLAG)) != UInt.constructor-impl((int)n3));
        n4 = 0;
        n4 = UInt.constructor-impl((int)(FLIPPED_HORIZONTALLY_FLAG | FLIPPED_VERTICALLY_FLAG));
        boolean bl = false;
        n4 = UInt.constructor-impl((int)(n4 | FLIPPED_DIAGONALLY_FLAG));
        bl = false;
        n4 = UInt.constructor-impl((int)(~n4));
        bl = false;
        n4 = UInt.constructor-impl((int)(gidUInt & n4));
        bl = false;
        int gid = n4;
        obj.setGid(gid);
        TypeIntrinsics.asMutableList(layer.getObjects()).add(obj);
    }

    private final void parseObjectProperty(TiledObject obj, StartElement start) {
        Object object;
        String propName = TMXLevelLoaderKt.access$getString(start, "name");
        String propType = TMXLevelLoaderKt.access$getString(start, "type");
        Map map = TypeIntrinsics.asMutableMap(obj.getPropertytypes());
        boolean bl = false;
        map.put(propName, propType);
        map = TypeIntrinsics.asMutableMap(obj.getProperties());
        switch (propType) {
            case "int": {
                object = TMXLevelLoaderKt.access$getInt(start, "value");
                break;
            }
            case "bool": {
                object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                break;
            }
            case "float": {
                object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                break;
            }
            case "": 
            case "string": {
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break;
            }
            case "color": {
                object = TMXLevelLoaderKt.access$getColor(start, "value");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
            }
        }
        Object object2 = object;
        boolean bl2 = false;
        map.put(propName, object2);
    }

    private final void parseTextProperty(TiledObject obj, String data, StartElement start) {
        TextData textData = new TextData(null, false, null, 7, null);
        textData.setText(data);
        textData.setColor(TMXLevelLoaderKt.access$getColor(start, "color"));
        obj.setTextData(textData);
    }

    private final void parseMapProperty(TiledMap map, StartElement start) {
        Object object;
        String propName = TMXLevelLoaderKt.access$getString(start, "name");
        String propType = TMXLevelLoaderKt.access$getString(start, "type");
        Map map2 = TypeIntrinsics.asMutableMap(map.getPropertytypes());
        boolean bl = false;
        map2.put(propName, propType);
        map2 = TypeIntrinsics.asMutableMap(map.getProperties());
        switch (propType) {
            case "int": {
                object = TMXLevelLoaderKt.access$getInt(start, "value");
                break;
            }
            case "bool": {
                object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                break;
            }
            case "float": {
                object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                break;
            }
            case "": 
            case "string": {
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break;
            }
            case "color": {
                object = TMXLevelLoaderKt.access$getColor(start, "value");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
            }
        }
        Object object2 = object;
        boolean bl2 = false;
        map2.put(propName, object2);
    }

    /*
     * WARNING - void declaration
     */
    private final void parseObjectPolygon(TiledObject obj, StartElement start) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        Object object;
        String it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String data = TMXLevelLoaderKt.access$getString(start, "points");
        Object object2 = data;
        String string = " +";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        object2 = string.split((CharSequence)object2, n);
        boolean $i$f$flatMap = false;
        String string2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            object = new String[]{","};
            list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            object = it;
            boolean bl4 = false;
            Double d = Double.parseDouble((String)object);
            collection.add(d);
        }
        double[] points = CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
        Polygon polygon = new Polygon(Arrays.copyOf(points, points.length));
        Map map = TypeIntrinsics.asMutableMap(obj.getProperties());
        string2 = "polygon";
        boolean bl5 = false;
        map.put(string2, polygon);
    }

    private static final void load$lambda-1(Level $level, String key, Object value) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof Float) {
            $level.getProperties().setValue(key, (Object)((Number)value).floatValue());
        } else {
            $level.getProperties().setValue(key, value);
        }
    }
}

