/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.state;

import com.almasb.fxgl.core.fsm.State;
import com.almasb.fxgl.core.fsm.StateMachine;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.state.EntityState;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;

public final class StateComponent
extends Component {
    private ReadOnlyObjectWrapper<EntityState> currentState;
    private StateMachine<EntityState> fsm;

    public StateComponent() {
        this(EntityState.IDLE);
    }

    public StateComponent(EntityState initialState) {
        this.currentState = new ReadOnlyObjectWrapper((Object)initialState);
        this.fsm = new StateMachine((State)initialState);
    }

    @Override
    public void onUpdate(double tpf) {
        this.getCurrentState().onUpdate(tpf);
    }

    public ReadOnlyObjectProperty<EntityState> currentStateProperty() {
        return this.currentState.getReadOnlyProperty();
    }

    public EntityState getCurrentState() {
        return (EntityState)this.fsm.getCurrentState();
    }

    public boolean isIdle() {
        return this.getCurrentState() == EntityState.IDLE;
    }

    public void changeStateToIdle() {
        this.changeState(EntityState.IDLE);
    }

    public void changeState(EntityState state) {
        if (this.getCurrentState() == state) {
            return;
        }
        this.fsm.changeState((State)state);
        this.currentState.setValue((Object)state);
    }

    public void changeStateAllowReentry(EntityState state) {
        this.fsm.changeState((State)state);
        this.currentState.setValue((Object)state);
    }

    public boolean isIn(EntityState ... states) {
        for (EntityState state : states) {
            if (state != this.getCurrentState()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

