/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.SAT;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import java.io.Serializable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class HitBox
implements Serializable {
    private String name;
    private BoundingShape shape;
    private Bounds bounds;
    Vec2[] axes = new Vec2[2];
    Vec2[] corners = new Vec2[4];
    private transient DoubleProperty minXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty minYWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxYWorld = new SimpleDoubleProperty();
    float fastMinX;
    float fastMinY;
    float fastMaxX;
    float fastMaxY;
    SAT.MinMax axis1MinMax = new SAT.MinMax();
    SAT.MinMax axis2MinMax = new SAT.MinMax();

    public HitBox(BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), shape);
    }

    public HitBox(Point2D localOrigin, BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), localOrigin, shape);
    }

    public HitBox(String name, BoundingShape shape) {
        this(name, Point2D.ZERO, shape);
    }

    public HitBox(String name, Point2D localOrigin, BoundingShape shape) {
        this.name = name;
        this.shape = shape;
        this.bounds = new BoundingBox(localOrigin.getX(), localOrigin.getY(), shape.getSize().getWidth(), shape.getSize().getHeight());
        this.axes[0] = new Vec2();
        this.axes[1] = new Vec2();
        for (int i = 0; i < 4; ++i) {
            this.corners[i] = new Vec2();
        }
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public BoundingShape getShape() {
        return this.shape;
    }

    public double getMinX() {
        return this.bounds.getMinX();
    }

    public double getMinY() {
        return this.bounds.getMinY();
    }

    public double getMaxX() {
        return this.bounds.getMaxX();
    }

    public double getMaxY() {
        return this.bounds.getMaxY();
    }

    public double getWidth() {
        return this.getMaxXWorld() - this.getMinXWorld();
    }

    public double getHeight() {
        return this.getMaxYWorld() - this.getMinYWorld();
    }

    public String getName() {
        return this.name;
    }

    public void bindXY(TransformComponent transform) {
        DoubleBinding x1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMinX()) * transform.getScaleX() + transform.getX(), (Observable[])new Observable[]{transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty()});
        DoubleBinding x2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMaxX()) * transform.getScaleX() + transform.getX(), (Observable[])new Observable[]{transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty()});
        DoubleBinding y1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMinY()) * transform.getScaleY() + transform.getY(), (Observable[])new Observable[]{transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty()});
        DoubleBinding y2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMaxY()) * transform.getScaleY() + transform.getY(), (Observable[])new Observable[]{transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty()});
        BooleanBinding isX1GreaterX2 = x1.greaterThan((ObservableNumberValue)x2);
        BooleanBinding isY1GreaterY2 = y1.greaterThan((ObservableNumberValue)y2);
        this.minXWorld.bind((ObservableValue)Bindings.when((ObservableBooleanValue)isX1GreaterX2).then((ObservableNumberValue)x2).otherwise((ObservableNumberValue)x1));
        this.maxXWorld.bind((ObservableValue)Bindings.when((ObservableBooleanValue)isX1GreaterX2).then((ObservableNumberValue)x1).otherwise((ObservableNumberValue)x2));
        this.minYWorld.bind((ObservableValue)Bindings.when((ObservableBooleanValue)isY1GreaterY2).then((ObservableNumberValue)y2).otherwise((ObservableNumberValue)y1));
        this.maxYWorld.bind((ObservableValue)Bindings.when((ObservableBooleanValue)isY1GreaterY2).then((ObservableNumberValue)y1).otherwise((ObservableNumberValue)y2));
    }

    public void unbind() {
        this.minXWorld.unbind();
        this.maxXWorld.unbind();
        this.minYWorld.unbind();
        this.maxYWorld.unbind();
    }

    public double getMinXWorld() {
        return this.minXWorld.get();
    }

    public double getMaxXWorld() {
        return this.maxXWorld.get();
    }

    public double getMinYWorld() {
        return this.minYWorld.get();
    }

    public double getMaxYWorld() {
        return this.maxYWorld.get();
    }

    public Point2D getCenterWorld() {
        return new Point2D((this.getMinXWorld() + this.getMaxXWorld()) / 2.0, (this.getMinYWorld() + this.getMaxYWorld()) / 2.0);
    }

    public Point2D centerLocal() {
        return new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / 2.0, (this.bounds.getMinY() + this.bounds.getMaxY()) / 2.0);
    }

    public Point2D centerWorld(double x, double y) {
        return this.centerLocal().add(x, y);
    }

    public Shape toBox2DShape(BoundingBoxComponent bbox, PhysicsUnitConverter converter) {
        return this.shape.toBox2DShape(this, bbox, converter);
    }

    public float getFastMinX() {
        return this.fastMinX;
    }

    public float getFastMinY() {
        return this.fastMinY;
    }

    public float getFastMaxX() {
        return this.fastMaxX;
    }

    public float getFastMaxY() {
        return this.fastMaxY;
    }

    public void applyTransform(TransformComponent transform) {
        double x1 = transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMinX()) * transform.getScaleX() + transform.getX();
        double x2 = transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMaxX()) * transform.getScaleX() + transform.getX();
        double y1 = transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMinY()) * transform.getScaleY() + transform.getY();
        double y2 = transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMaxY()) * transform.getScaleY() + transform.getY();
        this.fastMinX = (float)Math.min(x1, x2);
        this.fastMinY = (float)Math.min(y1, y2);
        this.fastMaxX = (float)Math.max(x1, x2);
        this.fastMaxY = (float)Math.max(y1, y2);
        double angle = transform.getAngle();
        float cos = FXGLMath.cosDegF((double)angle);
        float sin = FXGLMath.sinDegF((double)angle);
        this.axes[0].set(cos, sin).normalizeLocal();
        this.axes[1].set(FXGLMath.cosDegF((double)(angle + 90.0)), FXGLMath.sinDegF((double)(angle + 90.0))).normalizeLocal();
        this.corners[0].set(this.fastMinX, this.fastMinY);
        this.corners[1].set(this.fastMaxX, this.fastMinY);
        this.corners[2].set(this.fastMaxX, this.fastMaxY);
        this.corners[3].set(this.fastMinX, this.fastMaxY);
        if (angle != 0.0) {
            Point2D origin = transform.getRotationOrigin();
            double originX = origin.getX() + transform.getX();
            double originY = origin.getY() + transform.getY();
            for (Vec2 v : this.corners) {
                v.subLocal(originX, originY);
                v.set(v.x * cos - v.y * sin, v.x * sin + v.y * cos);
                v.addLocal(originX, originY);
            }
        }
        SAT.computeMinMax(this.corners, this.axes[0], this.axis1MinMax);
        SAT.computeMinMax(this.corners, this.axes[1], this.axis2MinMax);
    }

    public String toString() {
        return "HitBox(" + this.name + "," + this.shape + ")";
    }
}

