/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.ContactFilter;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.callbacks.DestructionListener;
import com.almasb.fxgl.physics.box2d.callbacks.ParticleDestructionListener;
import com.almasb.fxgl.physics.box2d.callbacks.ParticleQueryCallback;
import com.almasb.fxgl.physics.box2d.callbacks.ParticleRaycastCallback;
import com.almasb.fxgl.physics.box2d.callbacks.QueryCallback;
import com.almasb.fxgl.physics.box2d.callbacks.RayCastCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeRayCastCallback;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.TimeOfImpact;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.broadphase.DefaultBroadPhaseBuffer;
import com.almasb.fxgl.physics.box2d.collision.broadphase.DynamicTree;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyDef;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.ContactManager;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.Island;
import com.almasb.fxgl.physics.box2d.dynamics.TimeStep;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointEdge;
import com.almasb.fxgl.physics.box2d.particle.ParticleBodyContact;
import com.almasb.fxgl.physics.box2d.particle.ParticleColor;
import com.almasb.fxgl.physics.box2d.particle.ParticleContact;
import com.almasb.fxgl.physics.box2d.particle.ParticleDef;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroup;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroupDef;
import com.almasb.fxgl.physics.box2d.particle.ParticleSystem;
import com.almasb.fxgl.physics.box2d.pooling.DefaultWorldPool;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public final class World {
    private static final int WORLD_POOL_SIZE = 100;
    private static final int WORLD_POOL_CONTAINER_SIZE = 10;
    private final ContactManager contactManager;
    private final ParticleSystem particleSystem;
    private final IWorldPool pool;
    private DestructionListener destructionListener = null;
    private ParticleDestructionListener particleDestructionListener = null;
    private boolean newFixture = false;
    private boolean locked = false;
    private boolean autoClearForces = true;
    private boolean allowSleep = true;
    private boolean warmStarting = true;
    private boolean continuousPhysics = true;
    private boolean subStepping = false;
    private boolean stepComplete = true;
    private Array<Body> bodies = new Array(100);
    private Joint m_jointList = null;
    private int jointCount = 0;
    private final Vec2 gravity = new Vec2();
    private final TimeStep step = new TimeStep();
    private float dtInverse = 0.0f;
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final Island toiIsland = new Island();
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final TimeStep subStep = new TimeStep();
    private final Body[] tempBodies = new Body[2];
    private final Sweep backup1 = new Sweep();
    private final Sweep backup2 = new Sweep();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();

    public World(Vec2 gravity) {
        this.gravity.set(gravity);
        this.pool = new DefaultWorldPool(100, 10);
        this.contactManager = new ContactManager(this.pool, new DefaultBroadPhaseBuffer(new DynamicTree()));
        this.particleSystem = new ParticleSystem(this);
    }

    public Body createBody(BodyDef def) {
        this.assertNotLocked();
        Body b = new Body(def, this);
        this.bodies.add((Object)b);
        return b;
    }

    public void destroyBody(Body body) {
        this.assertNotLocked();
        body.destroy();
        this.bodies.removeValueByIdentity((Object)body);
    }

    public <T extends Joint> T createJoint(JointDef<T> def) {
        this.assertNotLocked();
        T j = Joint.create(this, def);
        ((Joint)j).m_prev = null;
        ((Joint)j).m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = j;
        }
        this.m_jointList = j;
        ++this.jointCount;
        ((Joint)j).m_edgeA.joint = j;
        ((Joint)j).m_edgeA.other = ((Joint)j).getBodyB();
        ((Joint)j).m_edgeA.prev = null;
        ((Joint)j).m_edgeA.next = ((Joint)j).getBodyA().m_jointList;
        if (((Joint)j).getBodyA().m_jointList != null) {
            ((Joint)j).getBodyA().m_jointList.prev = ((Joint)j).m_edgeA;
        }
        ((Joint)j).getBodyA().m_jointList = ((Joint)j).m_edgeA;
        ((Joint)j).m_edgeB.joint = j;
        ((Joint)j).m_edgeB.other = ((Joint)j).getBodyA();
        ((Joint)j).m_edgeB.prev = null;
        ((Joint)j).m_edgeB.next = ((Joint)j).getBodyB().m_jointList;
        if (((Joint)j).getBodyB().m_jointList != null) {
            ((Joint)j).getBodyB().m_jointList.prev = ((Joint)j).m_edgeB;
        }
        ((Joint)j).getBodyB().m_jointList = ((Joint)j).m_edgeB;
        Body bodyA = def.getBodyA();
        Body bodyB = def.getBodyB();
        if (!def.isBodyCollisionAllowed()) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        this.assertNotLocked();
        boolean collideConnected = j.getCollideConnected();
        if (j.m_prev != null) {
            j.m_prev.m_next = j.m_next;
        }
        if (j.m_next != null) {
            j.m_next.m_prev = j.m_prev;
        }
        if (j == this.m_jointList) {
            this.m_jointList = j.m_next;
        }
        Body bodyA = j.getBodyA();
        Body bodyB = j.getBodyB();
        bodyA.setAwake(true);
        bodyB.setAwake(true);
        if (j.m_edgeA.prev != null) {
            j.m_edgeA.prev.next = j.m_edgeA.next;
        }
        if (j.m_edgeA.next != null) {
            j.m_edgeA.next.prev = j.m_edgeA.prev;
        }
        if (j.m_edgeA == bodyA.m_jointList) {
            bodyA.m_jointList = j.m_edgeA.next;
        }
        j.m_edgeA.prev = null;
        j.m_edgeA.next = null;
        if (j.m_edgeB.prev != null) {
            j.m_edgeB.prev.next = j.m_edgeB.next;
        }
        if (j.m_edgeB.next != null) {
            j.m_edgeB.next.prev = j.m_edgeB.prev;
        }
        if (j.m_edgeB == bodyB.m_jointList) {
            bodyB.m_jointList = j.m_edgeB.next;
        }
        j.m_edgeB.prev = null;
        j.m_edgeB.next = null;
        Joint.destroy(j);
        assert (this.jointCount > 0);
        --this.jointCount;
        if (!collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
    }

    public void step(float dt, int velocityIterations, int positionIterations) {
        if (this.newFixture) {
            this.contactManager.findNewContacts();
            this.newFixture = false;
        }
        this.locked = true;
        this.step.dt = dt;
        this.step.velocityIterations = velocityIterations;
        this.step.positionIterations = positionIterations;
        this.step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        this.step.dtRatio = this.dtInverse * dt;
        this.step.warmStarting = this.warmStarting;
        this.contactManager.collide();
        if (this.step.dt > 0.0f) {
            if (this.stepComplete) {
                this.particleSystem.solve(this.step);
                this.solve(this.step);
            }
            if (this.continuousPhysics) {
                this.solveTOI(this.step);
            }
            this.dtInverse = this.step.inv_dt;
        }
        if (this.isAutoClearForces()) {
            this.clearForces();
        }
        this.locked = false;
    }

    private void solve(TimeStep step) {
        for (Body b : this.bodies) {
            b.m_xf0.set(b.m_xf);
        }
        this.island.init(this.getBodyCount(), this.contactManager.contactCount, this.jointCount, this.contactManager.getContactListener());
        for (Body b : this.bodies) {
            b.m_flags &= 0xFFFFFFFE;
        }
        Contact c = this.contactManager.contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFFE;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        int stackSize = this.getBodyCount();
        if (this.stack.length < stackSize) {
            this.stack = new Body[stackSize];
        }
        for (Body seed : this.bodies) {
            if ((seed.m_flags & 1) == 1 || !seed.isAwake() || !seed.isActive() || seed.getType() == BodyType.STATIC) continue;
            this.island.clear();
            int stackCount = 0;
            this.stack[stackCount++] = seed;
            seed.m_flags |= 1;
            while (stackCount > 0) {
                Body b = this.stack[--stackCount];
                this.island.add(b);
                b.setAwake(true);
                if (b.getType() == BodyType.STATIC) continue;
                ContactEdge ce = b.m_contactList;
                while (ce != null) {
                    Contact contact = ce.contact;
                    if ((contact.m_flags & 1) != 1 && contact.isEnabled() && contact.isTouching()) {
                        boolean sensorA = contact.m_fixtureA.isSensor();
                        boolean sensorB = contact.m_fixtureB.isSensor();
                        if (!sensorA && !sensorB) {
                            this.island.add(contact);
                            contact.m_flags |= 1;
                            Body other = ce.other;
                            if ((other.m_flags & 1) != 1) {
                                assert (stackCount < stackSize);
                                this.stack[stackCount++] = other;
                                other.m_flags |= 1;
                            }
                        }
                    }
                    ce = ce.next;
                }
                JointEdge je = b.m_jointList;
                while (je != null) {
                    Body other;
                    if (!je.joint.m_islandFlag && (other = je.other).isActive()) {
                        this.island.add(je.joint);
                        je.joint.m_islandFlag = true;
                        if ((other.m_flags & 1) != 1) {
                            assert (stackCount < stackSize);
                            this.stack[stackCount++] = other;
                            other.m_flags |= 1;
                        }
                    }
                    je = je.next;
                }
            }
            this.island.solve(step, this.gravity, this.allowSleep);
            this.island.postSolveCleanup();
        }
        for (Body b : this.bodies) {
            if ((b.m_flags & 1) == 0 || b.getType() == BodyType.STATIC) continue;
            b.synchronizeFixtures();
        }
        this.contactManager.findNewContacts();
    }

    private void solveTOI(TimeStep step) {
        block28: {
            Island island = this.toiIsland;
            island.init(2 * JBoxSettings.maxTOIContacts, JBoxSettings.maxTOIContacts, 0, this.contactManager.getContactListener());
            if (this.stepComplete) {
                for (Body b : this.bodies) {
                    b.m_flags &= 0xFFFFFFFE;
                    b.m_sweep.alpha0 = 0.0f;
                }
                Contact c = this.contactManager.contactList;
                while (c != null) {
                    c.m_flags &= 0xFFFFFFDE;
                    c.m_toiCount = 0.0f;
                    c.m_toi = 1.0f;
                    c = c.m_next;
                }
            }
            while (true) {
                Contact minContact = null;
                float minAlpha = 1.0f;
                Contact c = this.contactManager.contactList;
                while (c != null) {
                    block29: {
                        float alpha;
                        block31: {
                            boolean collideB;
                            boolean activeB;
                            block30: {
                                if (!c.isEnabled() || c.m_toiCount > (float)JBoxSettings.maxSubSteps) break block29;
                                alpha = 1.0f;
                                if ((c.m_flags & 0x20) == 0) break block30;
                                alpha = c.m_toi;
                                break block31;
                            }
                            Fixture fA = c.getFixtureA();
                            Fixture fB = c.getFixtureB();
                            if (fA.isSensor() || fB.isSensor()) break block29;
                            Body bA = fA.getBody();
                            Body bB = fB.getBody();
                            BodyType typeA = bA.getType();
                            BodyType typeB = bB.getType();
                            assert (typeA == BodyType.DYNAMIC || typeB == BodyType.DYNAMIC);
                            boolean activeA = bA.isAwake() && typeA != BodyType.STATIC;
                            boolean bl = activeB = bB.isAwake() && typeB != BodyType.STATIC;
                            if (!activeA && !activeB) break block29;
                            boolean collideA = bA.isBullet() || typeA != BodyType.DYNAMIC;
                            boolean bl2 = collideB = bB.isBullet() || typeB != BodyType.DYNAMIC;
                            if (!collideA && !collideB) break block29;
                            float alpha0 = bA.m_sweep.alpha0;
                            if (bA.m_sweep.alpha0 < bB.m_sweep.alpha0) {
                                alpha0 = bB.m_sweep.alpha0;
                                bA.m_sweep.advance(alpha0);
                            } else if (bB.m_sweep.alpha0 < bA.m_sweep.alpha0) {
                                alpha0 = bA.m_sweep.alpha0;
                                bB.m_sweep.advance(alpha0);
                            }
                            assert (alpha0 < 1.0f);
                            int indexA = c.getChildIndexA();
                            int indexB = c.getChildIndexB();
                            TimeOfImpact.TOIInput input = this.toiInput;
                            input.proxyA.set(fA.getShape(), indexA);
                            input.proxyB.set(fB.getShape(), indexB);
                            input.sweepA.set(bA.m_sweep);
                            input.sweepB.set(bB.m_sweep);
                            input.tMax = 1.0f;
                            this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, input);
                            float beta = this.toiOutput.t;
                            alpha = this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING ? Math.min(alpha0 + (1.0f - alpha0) * beta, 1.0f) : 1.0f;
                            c.m_toi = alpha;
                            c.m_flags |= 0x20;
                        }
                        if (alpha < minAlpha) {
                            minContact = c;
                            minAlpha = alpha;
                        }
                    }
                    c = c.m_next;
                }
                if (minContact == null || 0.9999988f < minAlpha) {
                    this.stepComplete = true;
                    break block28;
                }
                Fixture fA = minContact.getFixtureA();
                Fixture fB = minContact.getFixtureB();
                Body bA = fA.getBody();
                Body bB = fB.getBody();
                this.backup1.set(bA.m_sweep);
                this.backup2.set(bB.m_sweep);
                bA.advance(minAlpha);
                bB.advance(minAlpha);
                minContact.update(this.contactManager.getContactListener());
                minContact.m_flags &= 0xFFFFFFDF;
                minContact.m_toiCount += 1.0f;
                if (!minContact.isEnabled() || !minContact.isTouching()) {
                    minContact.setEnabled(false);
                    bA.m_sweep.set(this.backup1);
                    bB.m_sweep.set(this.backup2);
                    bA.synchronizeTransform();
                    bB.synchronizeTransform();
                    continue;
                }
                bA.setAwake(true);
                bB.setAwake(true);
                island.clear();
                island.add(bA);
                island.add(bB);
                island.add(minContact);
                bA.m_flags |= 1;
                bB.m_flags |= 1;
                minContact.m_flags |= 1;
                this.tempBodies[0] = bA;
                this.tempBodies[1] = bB;
                for (int i = 0; i < 2; ++i) {
                    Body body = this.tempBodies[i];
                    if (body.getType() != BodyType.DYNAMIC) continue;
                    ContactEdge ce = body.m_contactList;
                    while (ce != null && !island.isBodyCountEqualToCapacity() && !island.isContactCountEqualToCapacity()) {
                        Body other;
                        Contact contact = ce.contact;
                        if ((contact.m_flags & 1) == 0 && ((other = ce.other).getType() != BodyType.DYNAMIC || body.isBullet() || other.isBullet())) {
                            boolean sensorA = contact.m_fixtureA.isSensor();
                            boolean sensorB = contact.m_fixtureB.isSensor();
                            if (!sensorA && !sensorB) {
                                this.backup1.set(other.m_sweep);
                                if ((other.m_flags & 1) == 0) {
                                    other.advance(minAlpha);
                                }
                                contact.update(this.contactManager.getContactListener());
                                if (!contact.isEnabled()) {
                                    other.m_sweep.set(this.backup1);
                                    other.synchronizeTransform();
                                } else if (!contact.isTouching()) {
                                    other.m_sweep.set(this.backup1);
                                    other.synchronizeTransform();
                                } else {
                                    contact.m_flags |= 1;
                                    island.add(contact);
                                    if ((other.m_flags & 1) == 0) {
                                        other.m_flags |= 1;
                                        if (other.getType() != BodyType.STATIC) {
                                            other.setAwake(true);
                                        }
                                        island.add(other);
                                    }
                                }
                            }
                        }
                        ce = ce.next;
                    }
                }
                this.subStep.dt = (1.0f - minAlpha) * step.dt;
                this.subStep.inv_dt = 1.0f / this.subStep.dt;
                this.subStep.dtRatio = 1.0f;
                this.subStep.positionIterations = 20;
                this.subStep.velocityIterations = step.velocityIterations;
                this.subStep.warmStarting = false;
                island.solveTOI(this.subStep, bA.m_islandIndex, bB.m_islandIndex);
                island.resetFlagsAndSynchronizeBroadphaseProxies();
                this.contactManager.findNewContacts();
                if (this.subStepping) break;
            }
            this.stepComplete = false;
        }
    }

    public void queryAABB(QueryCallback callback, ParticleQueryCallback particleCallback, AABB aabb) {
        this.queryAABB(callback, aabb);
        this.queryAABB(particleCallback, aabb);
    }

    public void queryAABB(QueryCallback callback, AABB aabb) {
        this.wqwrapper.broadPhase = this.contactManager.broadPhase;
        this.wqwrapper.callback = callback;
        this.contactManager.broadPhase.query(this.wqwrapper, aabb);
    }

    public void queryAABB(ParticleQueryCallback particleCallback, AABB aabb) {
        this.particleSystem.queryAABB(particleCallback, aabb);
    }

    public void raycast(RayCastCallback callback, ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.raycast(callback, point1, point2);
        this.raycast(particleCallback, point1, point2);
    }

    public void raycast(RayCastCallback callback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.contactManager.broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.contactManager.broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public void raycast(ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.particleSystem.raycast(particleCallback, point1, point2);
    }

    public void clearForces() {
        for (Body body : this.bodies) {
            body.setForceToZero();
            body.setTorque(0.0f);
        }
    }

    public int createParticle(ParticleDef def) {
        this.assertNotLocked();
        return this.particleSystem.createParticle(def);
    }

    public void destroyParticle(int index) {
        this.destroyParticle(index, false);
    }

    public void destroyParticle(int index, boolean callDestructionListener) {
        this.particleSystem.destroyParticle(index, callDestructionListener);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf) {
        return this.destroyParticlesInShape(shape, xf, false);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf, boolean callDestructionListener) {
        this.assertNotLocked();
        return this.particleSystem.destroyParticlesInShape(shape, xf, callDestructionListener);
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef def) {
        this.assertNotLocked();
        return this.particleSystem.createParticleGroup(def);
    }

    public void joinParticleGroups(ParticleGroup groupA, ParticleGroup groupB) {
        this.assertNotLocked();
        this.particleSystem.joinParticleGroups(groupA, groupB);
    }

    public void destroyParticlesInGroup(ParticleGroup group, boolean callDestructionListener) {
        this.assertNotLocked();
        this.particleSystem.destroyParticlesInGroup(group, callDestructionListener);
    }

    public void destroyParticlesInGroup(ParticleGroup group) {
        this.destroyParticlesInGroup(group, false);
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.particleSystem.getParticleGroupList();
    }

    public int getParticleGroupCount() {
        return this.particleSystem.getParticleGroupCount();
    }

    public int getParticleCount() {
        return this.particleSystem.getParticleCount();
    }

    public int getParticleMaxCount() {
        return this.particleSystem.getParticleMaxCount();
    }

    public void setParticleMaxCount(int count) {
        this.particleSystem.setParticleMaxCount(count);
    }

    public void setParticleDensity(float density) {
        this.particleSystem.setParticleDensity(density);
    }

    public float getParticleDensity() {
        return this.particleSystem.getParticleDensity();
    }

    public void setParticleGravityScale(float gravityScale) {
        this.particleSystem.setParticleGravityScale(gravityScale);
    }

    public float getParticleGravityScale() {
        return this.particleSystem.getParticleGravityScale();
    }

    public void setParticleDamping(float damping) {
        this.particleSystem.setParticleDamping(damping);
    }

    public float getParticleDamping() {
        return this.particleSystem.getParticleDamping();
    }

    public void setParticleRadius(float radius) {
        this.particleSystem.setParticleRadius(radius);
    }

    public float getParticleRadius() {
        return this.particleSystem.getParticleRadius();
    }

    public int[] getParticleFlagsBuffer() {
        return this.particleSystem.getParticleFlagsBuffer();
    }

    public Vec2[] getParticlePositionBuffer() {
        return this.particleSystem.getParticlePositionBuffer();
    }

    public Vec2[] getParticleVelocityBuffer() {
        return this.particleSystem.getParticleVelocityBuffer();
    }

    public ParticleColor[] getParticleColorBuffer() {
        return this.particleSystem.getParticleColorBuffer();
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.particleSystem.getParticleGroupBuffer();
    }

    public Object[] getParticleUserDataBuffer() {
        return this.particleSystem.getParticleUserDataBuffer();
    }

    public void setParticleFlagsBuffer(int[] buffer, int capacity) {
        this.particleSystem.setParticleFlagsBuffer(buffer, capacity);
    }

    public void setParticlePositionBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticlePositionBuffer(buffer, capacity);
    }

    public void setParticleVelocityBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticleVelocityBuffer(buffer, capacity);
    }

    public void setParticleColorBuffer(ParticleColor[] buffer, int capacity) {
        this.particleSystem.setParticleColorBuffer(buffer, capacity);
    }

    public void setParticleUserDataBuffer(Object[] buffer, int capacity) {
        this.particleSystem.setParticleUserDataBuffer(buffer, capacity);
    }

    public ParticleContact[] getParticleContacts() {
        return this.particleSystem.m_contactBuffer;
    }

    public int getParticleContactCount() {
        return this.particleSystem.m_contactCount;
    }

    public ParticleBodyContact[] getParticleBodyContacts() {
        return this.particleSystem.m_bodyContactBuffer;
    }

    public int getParticleBodyContactCount() {
        return this.particleSystem.m_bodyContactCount;
    }

    public float computeParticleCollisionEnergy() {
        return this.particleSystem.computeParticleCollisionEnergy();
    }

    public Array<Body> getBodies() {
        return this.bodies;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public Contact getContactList() {
        return this.contactManager.contactList;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setSleepingAllowed(boolean sleepingAllowed) {
        this.allowSleep = sleepingAllowed;
    }

    public void setWarmStarting(boolean flag) {
        this.warmStarting = flag;
    }

    public boolean isWarmStarting() {
        return this.warmStarting;
    }

    public void setContinuousPhysics(boolean flag) {
        this.continuousPhysics = flag;
    }

    public boolean isContinuousPhysics() {
        return this.continuousPhysics;
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public int getContactCount() {
        return this.contactManager.contactCount;
    }

    public void setGravity(Vec2 gravity) {
        this.gravity.set(gravity);
    }

    public Vec2 getGravity() {
        return this.gravity;
    }

    ContactManager getContactManager() {
        return this.contactManager;
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public DestructionListener getDestructionListener() {
        return this.destructionListener;
    }

    public void setDestructionListener(DestructionListener listener) {
        this.destructionListener = listener;
    }

    public ParticleDestructionListener getParticleDestructionListener() {
        return this.particleDestructionListener;
    }

    public void setParticleDestructionListener(ParticleDestructionListener listener) {
        this.particleDestructionListener = listener;
    }

    public boolean isAllowSleep() {
        return this.allowSleep;
    }

    public void setAllowSleep(boolean flag) {
        if (flag == this.allowSleep) {
            return;
        }
        this.allowSleep = flag;
        if (!this.allowSleep) {
            for (Body b : this.bodies) {
                b.setAwake(true);
            }
        }
    }

    public void setSubStepping(boolean subStepping) {
        this.subStepping = subStepping;
    }

    public boolean isSubStepping() {
        return this.subStepping;
    }

    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public void setAutoClearForces(boolean flag) {
        this.autoClearForces = flag;
    }

    public boolean isAutoClearForces() {
        return this.autoClearForces;
    }

    public void setContactFilter(ContactFilter filter) {
        this.contactManager.setContactFilter(filter);
    }

    public void setContactListener(ContactListener listener) {
        this.contactManager.setContactListener(listener);
    }

    void notifyNewFixture() {
        this.newFixture = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    void assertNotLocked() {
        if (this.isLocked()) {
            throw new IllegalStateException("Physics world is locked during time step");
        }
    }

    private static class WorldQueryWrapper
    implements TreeCallback {
        BroadPhase broadPhase;
        QueryCallback callback;

        private WorldQueryWrapper() {
        }

        @Override
        public boolean treeCallback(int nodeId) {
            Fixture.FixtureProxy proxy = (Fixture.FixtureProxy)this.broadPhase.getUserData(nodeId);
            return this.callback.reportFixture(proxy.fixture);
        }
    }

    private static class WorldRayCastWrapper
    implements TreeRayCastCallback {
        private final RayCastOutput output = new RayCastOutput();
        private final Vec2 temp = new Vec2();
        private final Vec2 point = new Vec2();
        BroadPhase broadPhase;
        RayCastCallback callback;

        private WorldRayCastWrapper() {
        }

        @Override
        public float raycastCallback(RayCastInput input, int nodeId) {
            Object userData = this.broadPhase.getUserData(nodeId);
            Fixture.FixtureProxy proxy = (Fixture.FixtureProxy)userData;
            Fixture fixture = proxy.fixture;
            int index = proxy.childIndex;
            boolean hit = fixture.raycast(this.output, input, index);
            if (hit) {
                float fraction = this.output.fraction;
                this.temp.set(input.p2).mulLocal((double)fraction);
                this.point.set(input.p1).mulLocal((double)(1.0f - fraction)).addLocal(this.temp);
                return this.callback.reportFixture(fixture, this.point, this.output.normal, fraction);
            }
            return input.maxFraction;
        }
    }
}

