/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.joints;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.PulleyJoint;

public class PulleyJointDef
extends JointDef<PulleyJoint> {
    public Vec2 groundAnchorA = new Vec2(-1.0f, 1.0f);
    public Vec2 groundAnchorB = new Vec2(1.0f, 1.0f);
    public Vec2 localAnchorA = new Vec2(-1.0f, 0.0f);
    public Vec2 localAnchorB = new Vec2(1.0f, 0.0f);
    public float lengthA = 0.0f;
    public float lengthB = 0.0f;
    public float ratio = 1.0f;

    public PulleyJointDef() {
        this.setBodyCollisionAllowed(true);
    }

    public void initialize(Body b1, Body b2, Vec2 ga1, Vec2 ga2, Vec2 anchor1, Vec2 anchor2, float r) {
        this.setBodyA(b1);
        this.setBodyB(b2);
        this.groundAnchorA = ga1;
        this.groundAnchorB = ga2;
        this.localAnchorA = b1.getLocalPoint(anchor1);
        this.localAnchorB = b2.getLocalPoint(anchor2);
        Vec2 d1 = anchor1.sub(ga1);
        this.lengthA = d1.length();
        Vec2 d2 = anchor2.sub(ga2);
        this.lengthB = d2.length();
        this.ratio = r;
    }

    @Override
    protected PulleyJoint createJoint(World world) {
        return new PulleyJoint(world.getPool(), this);
    }
}

