/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.io;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.FileSystemAccess;
import com.almasb.fxgl.logging.Logger;
import com.gluonhq.attach.storage.StorageService;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0010J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J\"\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J0\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0013\u001a\u00020\u0010J:\u0010!\u001a&\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e \"*\u0012\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0010J@\u0010!\u001a&\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e \"*\u0012\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/almasb/fxgl/io/FileSystemService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "fs", "Lcom/almasb/fxgl/io/FileSystemAccess;", "isDesktop", "", "isFileSystemWriteAllowed", "log", "Lcom/almasb/fxgl/logging/Logger;", "checkWriteAllowed", "", "createDirectoryTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/lang/Void;", "dirName", "", "deleteDirectoryTask", "deleteFileTask", "fileName", "exists", "pathName", "loadDirectoryNamesTask", "", "recursive", "loadFileNamesTask", "extensions", "Lcom/almasb/fxgl/io/FileExtension;", "loadLastModifiedFileTask", "T", "normalize", "onInit", "readDataTask", "writeDataTask", "kotlin.jvm.PlatformType", "data", "Ljava/io/Serializable;", "text", "fxgl-io"})
public final class FileSystemService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @Inject(value="isDesktop")
    private boolean isDesktop = true;
    @Inject(value="isFileSystemWriteAllowed")
    private boolean isFileSystemWriteAllowed = true;
    private FileSystemAccess fs;

    public void onInit() {
        File rootStorage = this.isDesktop ? new File(Intrinsics.stringPlus((String)System.getProperty("user.dir"), (Object)"/")) : (File)StorageService.create().flatMap(FileSystemService::onInit$lambda-0).orElseThrow(FileSystemService::onInit$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)rootStorage, (String)"rootStorage");
        this.fs = new FileSystemAccess(rootStorage);
    }

    public final boolean exists(@NotNull String pathName) {
        Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
        FileSystemAccess fileSystemAccess = this.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.exists(pathName);
    }

    @NotNull
    public final IOTask<Void> createDirectoryTask(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        IOTask iOTask = IOTask.ofVoid((String)("createDirectoryTask(" + dirName + ')'), () -> FileSystemService.createDirectoryTask$lambda-2(this, dirName));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"ofVoid(\"createDirectoryTask($dirName)\") {\n        checkWriteAllowed()\n\n        fs.createDirectory(dirName)\n    }");
        return iOTask;
    }

    public final IOTask<Void> writeDataTask(@NotNull Serializable data, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return IOTask.ofVoid((String)("writeDataTask(" + fileName + ')'), () -> FileSystemService.writeDataTask$lambda-3(this, data, fileName));
    }

    public final IOTask<Void> writeDataTask(@NotNull List<String> text, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return IOTask.ofVoid((String)("writeDataTask(" + fileName + ')'), () -> FileSystemService.writeDataTask$lambda-4(this, text, fileName));
    }

    @NotNull
    public final <T> IOTask<T> readDataTask(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        IOTask iOTask = IOTask.of((String)("readDataTask(" + fileName + ')'), () -> FileSystemService.readDataTask$lambda-5(this, fileName));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"readDataTask($fileName)\") {\n        fs.readData<T>(fileName)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        IOTask iOTask = IOTask.of((String)("loadFileNamesTask(" + dirName + ", " + recursive + ')'), () -> FileSystemService.loadFileNamesTask$lambda-6(this, dirName, recursive));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"loadFileNamesTask($dirName, $recursive)\") {\n        fs.loadFileNames(dirName, recursive)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        IOTask iOTask = IOTask.of((String)("loadFileNamesTask(" + dirName + ", " + recursive + ", " + extensions + ')'), () -> FileSystemService.loadFileNamesTask$lambda-7(this, dirName, recursive, extensions));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"loadFileNamesTask($dirName, $recursive, $extensions)\") {\n        fs.loadFileNames(dirName, recursive, extensions)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadDirectoryNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        IOTask iOTask = IOTask.of((String)("loadDirectoryNamesTask(" + dirName + ", " + recursive + ')'), () -> FileSystemService.loadDirectoryNamesTask$lambda-8(this, dirName, recursive));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"loadDirectoryNamesTask($dirName, $recursive)\") {\n        fs.loadDirectoryNames(dirName, recursive)\n    }");
        return iOTask;
    }

    @NotNull
    public final <T> IOTask<T> loadLastModifiedFileTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        IOTask iOTask = IOTask.of((String)("loadLastModifiedFileTask(" + dirName + ", " + recursive + ')'), () -> FileSystemService.loadLastModifiedFileTask$lambda-9(this, dirName, recursive)).then(arg_0 -> FileSystemService.loadLastModifiedFileTask$lambda-10(this, dirName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"loadLastModifiedFileTask($dirName, $recursive)\") {\n        fs.loadLastModifiedFileName(dirName, recursive)\n    }.then { fileName -> readDataTask<T>(normalize(dirName) + fileName) }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> deleteFileTask(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        IOTask iOTask = IOTask.ofVoid((String)("deleteFileTask(" + fileName + ')'), () -> FileSystemService.deleteFileTask$lambda-11(this, fileName));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"ofVoid(\"deleteFileTask($fileName)\") {\n        checkWriteAllowed()\n\n        fs.deleteFile(fileName)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> deleteDirectoryTask(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        IOTask iOTask = IOTask.ofVoid((String)("deleteDirectoryTask(" + dirName + ')'), () -> FileSystemService.deleteDirectoryTask$lambda-12(this, dirName));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"ofVoid(\"deleteDirectoryTask($dirName)\") {\n        checkWriteAllowed()\n\n        fs.deleteDirectory(dirName)\n    }");
        return iOTask;
    }

    private final String normalize(String dirName) {
        return StringsKt.endsWith$default((CharSequence)dirName, (char)File.separatorChar, (boolean)false, (int)2, null) ? dirName : Intrinsics.stringPlus((String)dirName, (Object)Character.valueOf(File.separatorChar));
    }

    private final void checkWriteAllowed() {
        boolean bl = this.isFileSystemWriteAllowed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            this.log.warning("Attempted to make a write call but FS write is not allowed");
            String string = "isFileSystemWriteAllowed is false";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private static final Optional onInit$lambda-0(StorageService it) {
        return it.getPrivateStorage();
    }

    private static final RuntimeException onInit$lambda-1() {
        return new RuntimeException("No private storage present");
    }

    private static final void createDirectoryTask$lambda-2(FileSystemService this$0, String $dirName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        fileSystemAccess.createDirectory($dirName);
    }

    private static final void writeDataTask$lambda-3(FileSystemService this$0, Serializable $data, String $fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        fileSystemAccess.writeData($data, $fileName);
    }

    private static final void writeDataTask$lambda-4(FileSystemService this$0, List $text, String $fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        fileSystemAccess.writeData($text, $fileName);
    }

    private static final Object readDataTask$lambda-5(FileSystemService this$0, String $fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.readData($fileName);
    }

    private static final List loadFileNamesTask$lambda-6(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.loadFileNames($dirName, $recursive);
    }

    private static final List loadFileNamesTask$lambda-7(FileSystemService this$0, String $dirName, boolean $recursive, List $extensions) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        Intrinsics.checkNotNullParameter((Object)$extensions, (String)"$extensions");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.loadFileNames($dirName, $recursive, $extensions);
    }

    private static final List loadDirectoryNamesTask$lambda-8(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.loadDirectoryNames($dirName, $recursive);
    }

    private static final String loadLastModifiedFileTask$lambda-9(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        return fileSystemAccess.loadLastModifiedFileName($dirName, $recursive);
    }

    private static final IOTask loadLastModifiedFileTask$lambda-10(FileSystemService this$0, String $dirName, String fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        return this$0.readDataTask(Intrinsics.stringPlus((String)this$0.normalize($dirName), (Object)fileName));
    }

    private static final void deleteFileTask$lambda-11(FileSystemService this$0, String $fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        fileSystemAccess.deleteFile($fileName);
    }

    private static final void deleteDirectoryTask$lambda-12(FileSystemService this$0, String $dirName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dirName, (String)"$dirName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
            throw null;
        }
        fileSystemAccess.deleteDirectory($dirName);
    }
}

