/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.udp;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Client;
import com.almasb.fxgl.net.Connection;
import com.almasb.fxgl.net.UDPClientConfig;
import com.almasb.fxgl.net.udp.UDPClientKt;
import com.almasb.fxgl.net.udp.UDPConnection;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/net/udp/UDPClient;", "T", "Lcom/almasb/fxgl/net/Client;", "ip", "", "port", "", "config", "Lcom/almasb/fxgl/net/UDPClientConfig;", "(Ljava/lang/String;ILcom/almasb/fxgl/net/UDPClientConfig;)V", "getIp", "()Ljava/lang/String;", "isStopped", "", "log", "Lcom/almasb/fxgl/logging/Logger;", "getPort", "()I", "socket", "Ljava/net/DatagramSocket;", "connect", "", "disconnect", "fxgl-io"})
public final class UDPClient<T>
extends Client<T> {
    @NotNull
    private final String ip;
    private final int port;
    @NotNull
    private final UDPClientConfig<T> config;
    @NotNull
    private final Logger log;
    private boolean isStopped;
    @Nullable
    private DatagramSocket socket;

    public UDPClient(@NotNull String ip, int port, @NotNull UDPClientConfig<T> config) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.ip = ip;
        this.port = port;
        this.config = config;
        this.log = Logger.Companion.get(this.getClass());
    }

    @NotNull
    public final String getIp() {
        return this.ip;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect() {
        Closeable closeable = new DatagramSocket();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            UDPConnection connection;
            DatagramSocket it = (DatagramSocket)closeable;
            boolean bl3 = false;
            this.socket = it;
            it.connect(InetAddress.getByName(this.getIp()), this.getPort());
            List list = this.getConnections();
            Intrinsics.checkNotNullExpressionValue(list, (String)"connections");
            Object object = CollectionsKt.firstOrNull(list);
            UDPConnection uDPConnection = connection = object instanceof UDPConnection ? (UDPConnection)object : null;
            if (connection == null) {
                connection = new UDPConnection(it, this.getIp(), this.getPort(), this.config.getBufferSize(), 1);
                this.openUDPConnection(connection, this.config.getMessageType());
                DatagramPacket packet = new DatagramPacket(UDPClientKt.getMESSAGE_OPEN(), UDPClientKt.getMESSAGE_OPEN().length);
                it.send(packet);
            }
            byte[] buffer = new byte[this.config.getBufferSize()];
            while (!this.isStopped) {
                Arrays.fill(buffer, (byte)0);
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                it.receive(packet);
                boolean isClosingPacket = Arrays.equals(Arrays.copyOfRange(packet.getData(), 0, UDPClientKt.getMESSAGE_CLOSE().length), UDPClientKt.getMESSAGE_CLOSE());
                if (isClosingPacket) {
                    this.isStopped = true;
                    this.onConnectionClosed(connection);
                    continue;
                }
                byte[] byArray = packet.getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"packet.data");
                connection.receive$fxgl_io(byArray);
            }
            if (it.isClosed()) {
                this.onConnectionClosed(connection);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void disconnect() {
        if (this.isStopped) {
            this.log.warning("Attempted to stop a client that is already stopped");
            return;
        }
        this.isStopped = true;
        List list = this.getConnections();
        Intrinsics.checkNotNullExpressionValue(list, (String)"connections");
        Object $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Connection it = (Connection)element$iv;
            boolean bl = false;
            it.terminate();
        }
        try {
            $this$forEach$iv = this.socket;
            if ($this$forEach$iv != null) {
                ((DatagramSocket)$this$forEach$iv).close();
            }
        }
        catch (Exception e) {
            this.log.warning(Intrinsics.stringPlus((String)"Exception when closing client socket: ", (Object)e.getMessage()), (Throwable)e);
        }
    }
}

