/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.OperationIdGenerator;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.github.aoudiamoncef.apollo.plugin.config.CompilationUnit;
import com.github.aoudiamoncef.apollo.plugin.config.CompilerParams;
import com.github.aoudiamoncef.apollo.plugin.config.Introspection;
import com.github.aoudiamoncef.apollo.plugin.config.Service;
import com.github.aoudiamoncef.apollo.plugin.util.ConfigUtils;
import com.github.aoudiamoncef.apollo.plugin.util.SchemaDownloader;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okhttp3.OkHttpClient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/GraphQLClientMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "project", "Lorg/apache/maven/project/MavenProject;", "services", "", "", "Lcom/github/aoudiamoncef/apollo/plugin/config/Service;", "skip", "", "execute", "", "apollo-client-maven-plugin"})
@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public final class GraphQLClientMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private final boolean skip;
    @Parameter
    private Map<String, Service> services;

    public void execute() throws MojoExecutionException {
        Object[] objectArray;
        long start = System.nanoTime();
        if (this.skip) {
            this.getLog().info((CharSequence)"Apollo GraphQL Client code generation skipping execution because skip option is true");
            return;
        }
        this.getLog().info((CharSequence)"Apollo GraphQL Client code generation task started");
        Map<String, Service> map = this.services;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"services");
            throw null;
        }
        Iterable $this$forEach$iv = map.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationOutputGenerator.DefaultOperationOuputGenerator defaultOperationOuputGenerator;
            Object object;
            boolean bl;
            List<File> list;
            Object object2;
            Object okHttpClient;
            Object schema;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            if (!((Service)it.getValue()).getEnabled$apollo_client_maven_plugin()) {
                this.getLog().info((CharSequence)("Skipping generation of service: " + (String)it.getKey() + " because enabled option is false"));
                continue;
            }
            objectArray = this.project;
            if (objectArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            Service service = ConfigUtils.INSTANCE.checkService$apollo_client_maven_plugin((MavenProject)objectArray, (String)it.getKey(), (Service)it.getValue());
            MavenProject mavenProject = this.project;
            if (mavenProject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            CompilationUnit compilationUnit = ConfigUtils.INSTANCE.checkCompilationUnit$apollo_client_maven_plugin(mavenProject, (String)it.getKey(), service.getCompilationUnit$apollo_client_maven_plugin());
            MavenProject mavenProject2 = this.project;
            if (mavenProject2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            CompilerParams compilerParams = ConfigUtils.INSTANCE.checkCompilerParams$apollo_client_maven_plugin(mavenProject2, service, compilationUnit.getCompilerParams$apollo_client_maven_plugin());
            Object object3 = this.project;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            Introspection introspection = ConfigUtils.INSTANCE.checkIntrospection$apollo_client_maven_plugin((MavenProject)object3, service);
            this.getLog().info((CharSequence)Intrinsics.stringPlus((String)"Generating service: ", it.getKey()));
            if (introspection.getEnabled$apollo_client_maven_plugin()) {
                this.getLog().info((CharSequence)Intrinsics.stringPlus((String)"Automatically generating introspection file from: ", (Object)introspection.getEndpointUrl$apollo_client_maven_plugin()));
                object3 = introspection.getSchemaFile$apollo_client_maven_plugin();
                boolean bl3 = false;
                boolean bl4 = false;
                schema = object3;
                boolean bl5 = false;
                okHttpClient = SchemaDownloader.INSTANCE.newOkHttpClient(introspection.getConnectTimeoutSeconds$apollo_client_maven_plugin(), introspection.getReadTimeoutSeconds$apollo_client_maven_plugin(), introspection.getWriteTimeoutSeconds$apollo_client_maven_plugin(), introspection.getUseSelfSignedCertificat$apollo_client_maven_plugin(), introspection.getUseGzip$apollo_client_maven_plugin());
                object2 = introspection.getEndpointUrl$apollo_client_maven_plugin();
                boolean bl6 = false;
                if (object2.length() > 0) {
                    if (schema == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.io.File");
                    }
                    object2 = schema;
                    String string = introspection.getEndpointUrl$apollo_client_maven_plugin();
                    list = introspection.getHeaders$apollo_client_maven_plugin();
                    bl = introspection.getPrettyPrint$apollo_client_maven_plugin();
                    SchemaDownloader.INSTANCE.downloadIntrospection(string, (File)object2, (Map<String, String>)((Object)list), bl, (OkHttpClient)okHttpClient);
                } else {
                    object2 = introspection.getGraph$apollo_client_maven_plugin();
                    bl6 = false;
                    if (object2.length() > 0) {
                        if (schema == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.io.File");
                        }
                        object2 = schema;
                        String string = introspection.getGraph$apollo_client_maven_plugin();
                        list = introspection.getKey$apollo_client_maven_plugin();
                        object = introspection.getGraphVariant$apollo_client_maven_plugin();
                        boolean bl7 = introspection.getPrettyPrint$apollo_client_maven_plugin();
                        SchemaDownloader.INSTANCE.downloadRegistry(string, (File)object2, (String)((Object)list), (String)object, bl7, (OkHttpClient)okHttpClient);
                    }
                }
            }
            this.getLog().info((CharSequence)"Read schema file");
            File file = service.getSourceFolder$apollo_client_maven_plugin();
            if (file == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.File");
            }
            Set<File> sourceSetFiles = ConfigUtils.INSTANCE.getSourceSetFiles$apollo_client_maven_plugin(file, service.getIncludes$apollo_client_maven_plugin(), service.getExcludes$apollo_client_maven_plugin());
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**.{json,sdl,graphqls}");
            Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getDefault().getPathMatcher(\"glob:**.{json,sdl,graphqls}\")");
            PathMatcher schemaMatcher = pathMatcher;
            Set<File> directories = ConfigUtils.INSTANCE.findFilesByMatcher$apollo_client_maven_plugin(sourceSetFiles, schemaMatcher);
            MavenProject bl5 = this.project;
            if (bl5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            schema = ConfigUtils.INSTANCE.resolveSchema$apollo_client_maven_plugin(bl5, service.getSchemaPath$apollo_client_maven_plugin(), directories, sourceSetFiles);
            this.getLog().info((CharSequence)"Read querie(s)/fragment(s) files");
            okHttpClient = FileSystems.getDefault().getPathMatcher("glob:**.{graphql,gql,graphqls}");
            Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"getDefault().getPathMatcher(\"glob:**.{graphql,gql,graphqls}\")");
            Object graphqlMatcher = okHttpClient;
            Object object4 = ConfigUtils.INSTANCE.findFilesByMatcher$apollo_client_maven_plugin(sourceSetFiles, (PathMatcher)graphqlMatcher);
            boolean bl8 = false;
            bl = false;
            Set<File> set = object4;
            boolean bl9 = false;
            Object object5 = set;
            boolean bl10 = false;
            Object object6 = object2 = !object5.isEmpty() ? object4 : null;
            if (object2 == null) {
                throw new MojoExecutionException("No querie(s)/fragment(s) found");
            }
            Object graphqlFiles = object2;
            object4 = compilerParams.getOperationIdGeneratorClass$apollo_client_maven_plugin();
            bl8 = false;
            if (object4.length() == 0) {
                defaultOperationOuputGenerator = new OperationOutputGenerator.DefaultOperationOuputGenerator((OperationIdGenerator)new OperationIdGenerator.Sha256());
            } else {
                Object obj = Class.forName(compilerParams.getOperationIdGeneratorClass$apollo_client_maven_plugin()).newInstance();
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo.compiler.OperationIdGenerator");
                }
                OperationIdGenerator operationIdGenerator = (OperationIdGenerator)obj;
                defaultOperationOuputGenerator = new OperationOutputGenerator.DefaultOperationOuputGenerator(operationIdGenerator);
            }
            OperationOutputGenerator.DefaultOperationOuputGenerator operationOutputGenerator = defaultOperationOuputGenerator;
            GraphQLCompiler compiler = new GraphQLCompiler(null, 1, null);
            list = compilerParams.getRootFolders$apollo_client_maven_plugin();
            Object object7 = compilationUnit.getOutputDirectory$apollo_client_maven_plugin();
            if (object7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.File");
            }
            object = object7;
            object7 = compilerParams.getMetadata$apollo_client_maven_plugin();
            String string = compilerParams.getModuleName$apollo_client_maven_plugin();
            object5 = compilerParams.getRootProjectDir$apollo_client_maven_plugin();
            File file2 = compilerParams.getMetadataOutputFile$apollo_client_maven_plugin();
            if (file2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.File");
            }
            File file3 = file2;
            boolean bl11 = compilerParams.getGenerateApolloMetadata$apollo_client_maven_plugin();
            Set<String> set2 = compilerParams.getAlwaysGenerateTypesMatching$apollo_client_maven_plugin();
            File file4 = compilationUnit.getOperationOutputFile$apollo_client_maven_plugin();
            String string2 = compilerParams.getRootPackageName$apollo_client_maven_plugin();
            String string3 = compilerParams.getPackageName$apollo_client_maven_plugin();
            boolean bl12 = compilerParams.getGenerateKotlinModels$apollo_client_maven_plugin();
            Map<String, String> map2 = compilerParams.getCustomTypeMapping$apollo_client_maven_plugin();
            boolean bl13 = compilerParams.getUseSemanticNaming$apollo_client_maven_plugin();
            boolean bl14 = compilerParams.getGenerateAsInternal$apollo_client_maven_plugin();
            boolean bl15 = compilerParams.getWarnOnDeprecatedUsages$apollo_client_maven_plugin();
            boolean bl16 = compilerParams.getFailOnWarnings$apollo_client_maven_plugin();
            boolean bl17 = compilerParams.getKotlinMultiPlatformProject$apollo_client_maven_plugin();
            Set<String> set3 = compilerParams.getSealedClassesForEnumsMatching$apollo_client_maven_plugin();
            NullableValueType nullableValueType = compilerParams.getNullableValueType$apollo_client_maven_plugin();
            boolean bl18 = compilerParams.getGenerateModelBuilder$apollo_client_maven_plugin();
            boolean bl19 = compilerParams.getUseJavaBeansSemanticNaming$apollo_client_maven_plugin();
            boolean bl20 = compilerParams.getSuppressRawTypesWarning$apollo_client_maven_plugin();
            boolean bl21 = compilerParams.getGenerateVisitorForPolymorphicDatatypes$apollo_client_maven_plugin();
            compiler.write(new GraphQLCompiler.Arguments(list, (Set)graphqlFiles, (File)schema, (File)object, (List)object7, string, (File)object5, file3, bl11, set2, file4, (OperationOutputGenerator)operationOutputGenerator, string2, bl12, map2, bl13, bl14, bl15, bl16, string3, bl17, set3, nullableValueType, bl18, bl19, bl20, bl21));
            if (!service.getAddSourceRoot$apollo_client_maven_plugin()) continue;
            object = compilationUnit.getOutputDirectory$apollo_client_maven_plugin();
            String generatedSourcePath = object == null ? null : ((File)object).getCanonicalPath();
            this.getLog().info((CharSequence)("Add the compiled sources from " + generatedSourcePath + " to project root"));
            object = this.project;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                throw null;
            }
            object.addCompileSourceRoot(generatedSourcePath);
        }
        this.getLog().info((CharSequence)"Apollo GraphQL Client code generation task finished");
        long finish = System.nanoTime();
        double timeElapsed = (double)(finish - start) / (double)1000000000;
        Log log = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Total time: ");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.3f";
        objectArray = new Object[]{timeElapsed};
        boolean bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        log.info((CharSequence)stringBuilder.append(string4).append(" s").toString());
    }
}

