/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin.util;

import com.github.aoudiamoncef.apollo.plugin.config.CompilationUnit;
import com.github.aoudiamoncef.apollo.plugin.config.CompilerParams;
import com.github.aoudiamoncef.apollo.plugin.config.Introspection;
import com.github.aoudiamoncef.apollo.plugin.config.Service;
import com.github.aoudiamoncef.apollo.plugin.util.BuildDirLayout;
import com.github.aoudiamoncef.apollo.plugin.util.ConfigUtils;
import java.io.File;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013J%\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0015J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ7\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0000\u00a2\u0006\u0002\b!J;\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a2\u0006\u0002\b&\u00a8\u0006'"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/util/ConfigUtils;", "", "()V", "checkCompilationUnit", "Lcom/github/aoudiamoncef/apollo/plugin/config/CompilationUnit;", "project", "Lorg/apache/maven/project/MavenProject;", "serviceName", "", "compilationUnit", "checkCompilationUnit$apollo_client_maven_plugin", "checkCompilerParams", "Lcom/github/aoudiamoncef/apollo/plugin/config/CompilerParams;", "service", "Lcom/github/aoudiamoncef/apollo/plugin/config/Service;", "compilerParams", "checkCompilerParams$apollo_client_maven_plugin", "checkIntrospection", "Lcom/github/aoudiamoncef/apollo/plugin/config/Introspection;", "checkIntrospection$apollo_client_maven_plugin", "checkService", "checkService$apollo_client_maven_plugin", "findFilesByMatcher", "", "Ljava/io/File;", "files", "matcher", "Ljava/nio/file/PathMatcher;", "findFilesByMatcher$apollo_client_maven_plugin", "getSourceSetFiles", "sourceFolder", "includes", "excludes", "getSourceSetFiles$apollo_client_maven_plugin", "resolveSchema", "schemaPath", "directories", "sourceSetFiles", "resolveSchema$apollo_client_maven_plugin", "apollo-client-maven-plugin"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE = new ConfigUtils();

    private ConfigUtils() {
    }

    @NotNull
    public final Service checkService$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String serviceName, @NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        service.setIntrospection$apollo_client_maven_plugin(service.isIntrospectionInitialised() ? service.getIntrospection$apollo_client_maven_plugin() : new Introspection());
        service.setCompilationUnit$apollo_client_maven_plugin(service.isCompilationUnitInitialised() ? service.getCompilationUnit$apollo_client_maven_plugin() : new CompilationUnit());
        if (service.getSourceFolder$apollo_client_maven_plugin() == null) {
            CharSequence charSequence = service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin();
            boolean bl = false;
            String compilationUnitName = !StringsKt.isBlank((CharSequence)charSequence) ? service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() : serviceName;
            File sourceFolder = new File(project.getBasedir() + "/src/main/graphql/" + compilationUnitName);
            sourceFolder.getParentFile().mkdirs();
            service.setSourceFolder$apollo_client_maven_plugin(sourceFolder);
        }
        return service;
    }

    @NotNull
    public final CompilationUnit checkCompilationUnit$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String serviceName, @NotNull CompilationUnit compilationUnit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        compilationUnit.setCompilerParams$apollo_client_maven_plugin(compilationUnit.isCompilationparamsInitialised() ? compilationUnit.getCompilerParams$apollo_client_maven_plugin() : new CompilerParams());
        if (StringsKt.isBlank((CharSequence)compilationUnit.getName$apollo_client_maven_plugin())) {
            compilationUnit.setName$apollo_client_maven_plugin(serviceName);
        }
        if (compilationUnit.getGenerateOperationDescriptors$apollo_client_maven_plugin()) {
            if (compilationUnit.getOperationOutputFile$apollo_client_maven_plugin() == null) {
                File operationOuput = BuildDirLayout.INSTANCE.operationOuput$apollo_client_maven_plugin(project, compilationUnit);
                operationOuput.getParentFile().mkdirs();
                operationOuput.createNewFile();
                compilationUnit.setOperationOutputFile$apollo_client_maven_plugin(operationOuput);
            } else {
                File file;
                File file2 = compilationUnit.getOperationOutputFile$apollo_client_maven_plugin();
                if (file2 != null && (file = file2.getParentFile()) != null) {
                    file.mkdirs();
                }
                if ((file2 = compilationUnit.getOperationOutputFile$apollo_client_maven_plugin()) != null) {
                    file2.createNewFile();
                }
            }
        } else {
            compilationUnit.setOperationOutputFile$apollo_client_maven_plugin(null);
        }
        if (compilationUnit.getOutputDirectory$apollo_client_maven_plugin() == null) {
            compilationUnit.setOutputDirectory$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.sources$apollo_client_maven_plugin(project, compilationUnit));
        }
        return compilationUnit;
    }

    @NotNull
    public final Introspection checkIntrospection$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Introspection introspection = service.getIntrospection$apollo_client_maven_plugin();
        if (introspection.getEnabled$apollo_client_maven_plugin()) {
            if (StringsKt.isBlank((CharSequence)introspection.getEndpointUrl$apollo_client_maven_plugin())) {
                throw new MojoExecutionException("introspection: must have a url");
            }
            if (introspection.getSchemaFile$apollo_client_maven_plugin() == null) {
                File schemaFile;
                CharSequence charSequence = service.getSchemaPath$apollo_client_maven_plugin();
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    schemaFile = new File(service.getSchemaPath$apollo_client_maven_plugin());
                    schemaFile.getParentFile().mkdirs();
                    schemaFile.createNewFile();
                    introspection.setSchemaFile$apollo_client_maven_plugin(schemaFile);
                } else {
                    schemaFile = new File(project.getBasedir() + "/src/main/graphql/" + service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin() + "/schema.json");
                    schemaFile.getParentFile().mkdirs();
                    schemaFile.createNewFile();
                    introspection.setSchemaFile$apollo_client_maven_plugin(schemaFile);
                }
            }
        }
        return introspection;
    }

    @NotNull
    public final CompilerParams checkCompilerParams$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull Service service, @NotNull CompilerParams compilerParams) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)compilerParams, (String)"compilerParams");
        Object object = compilerParams.getRootFolders$apollo_client_maven_plugin();
        boolean bl = false;
        if (!object.isEmpty()) {
            list = compilerParams.getRootFolders$apollo_client_maven_plugin();
        } else {
            object = service.getSourceFolder$apollo_client_maven_plugin();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.File");
            }
            list = CollectionsKt.listOf((Object)object);
        }
        compilerParams.setRootFolders$apollo_client_maven_plugin(list);
        if (compilerParams.getMetadataOutputFile$apollo_client_maven_plugin() == null) {
            compilerParams.setMetadataOutputFile$apollo_client_maven_plugin(BuildDirLayout.INSTANCE.metadata$apollo_client_maven_plugin(project, service.getCompilationUnit$apollo_client_maven_plugin()));
        }
        if (compilerParams.getGenerateApolloMetadata$apollo_client_maven_plugin() && compilerParams.getAlwaysGenerateTypesMatching$apollo_client_maven_plugin().isEmpty()) {
            compilerParams.setAlwaysGenerateTypesMatching$apollo_client_maven_plugin(SetsKt.setOf((Object)".*"));
        }
        if (StringsKt.isBlank((CharSequence)compilerParams.getRootPackageName$apollo_client_maven_plugin())) {
            object = compilerParams.getPackageName$apollo_client_maven_plugin();
            bl = false;
            boolean bl2 = false;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                compilerParams.setRootPackageName$apollo_client_maven_plugin(project.getGroupId() + ".apollo.client." + service.getCompilationUnit$apollo_client_maven_plugin().getName$apollo_client_maven_plugin());
            }
        }
        return compilerParams;
    }

    @NotNull
    public final Set<File> findFilesByMatcher$apollo_client_maven_plugin(@NotNull Set<? extends File> files, @NotNull PathMatcher matcher) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)((Function1)new Function1<File, Boolean>(matcher){
            final /* synthetic */ PathMatcher $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            public final boolean invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.$matcher.matches(file.toPath());
            }
        })));
    }

    @NotNull
    public final Set<File> getSourceSetFiles$apollo_client_maven_plugin(@NotNull File sourceFolder, @NotNull Set<String> includes, @NotNull Set<String> excludes) {
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        String[] stringArray = new DirectoryScanner();
        boolean bl = false;
        boolean bl2 = false;
        String[] $this$getSourceSetFiles_u24lambda_u2d0 = stringArray;
        boolean bl3 = false;
        $this$getSourceSetFiles_u24lambda_u2d0.setBasedir(sourceFolder);
        $this$getSourceSetFiles_u24lambda_u2d0.setCaseSensitive(false);
        Collection $this$toTypedArray$iv = includes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$getSourceSetFiles_u24lambda_u2d0.setIncludes(stringArray2);
        $this$toTypedArray$iv = excludes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$getSourceSetFiles_u24lambda_u2d0.addExcludes(stringArray3);
        $this$getSourceSetFiles_u24lambda_u2d0.scan();
        String[] scanner = stringArray;
        stringArray = scanner.getIncludedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"scanner.includedFiles");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])stringArray), (Function1)((Function1)new Function1<String, File>(sourceFolder){
            final /* synthetic */ File $sourceFolder;
            {
                this.$sourceFolder = $sourceFolder;
                super(1);
            }

            public final File invoke(String path) {
                String[] stringArray = new String[]{path};
                return Paths.get(this.$sourceFolder.getPath(), stringArray).toFile();
            }
        })), (Function1)getSourceSetFiles.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File resolveSchema$apollo_client_maven_plugin(@NotNull MavenProject project, @NotNull String schemaPath, @NotNull Set<? extends File> directories, @NotNull Set<? extends File> sourceSetFiles) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Intrinsics.checkNotNullParameter(sourceSetFiles, (String)"sourceSetFiles");
        CharSequence charSequence = schemaPath;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            if (FilesKt.isRooted((File)new File(schemaPath))) {
                return new File(schemaPath);
            }
            if (StringsKt.startsWith$default((String)schemaPath, (String)"..", (boolean)false, (int)2, null)) {
                return FilesKt.normalize((File)new File(project.getBasedir() + "/src/main/graphql/" + schemaPath));
            }
            boolean bl2 = sourceSetFiles.size() <= 1;
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)"ApolloGraphQL: duplicate(s) schema file(s) found:\n", (Object)CollectionsKt.joinToString$default((Iterable)sourceSetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)resolveSchema.1.1.INSTANCE, (int)30, null));
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = sourceSetFiles.size() == 1;
            bl = false;
            bl3 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "ApolloGraphQL: cannot find a schema file at " + schemaPath + ". Tried:\n" + CollectionsKt.joinToString$default((Iterable)sourceSetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)resolveSchema.2.1.INSTANCE, (int)30, null);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return (File)CollectionsKt.first((Iterable)sourceSetFiles);
        }
        Iterable $this$flatMap$iv = directories;
        boolean $i$f$flatMap = false;
        Iterable bl5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File srcDir = (File)element$iv$iv;
            boolean bl6 = false;
            Iterable list$iv$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)srcDir)), (Function1)resolveSchema.candidates.1.1.INSTANCE));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List candidates2 = (List)destination$iv$iv;
        boolean bl7 = candidates2.size() <= 1;
        boolean bl8 = false;
        boolean bl9 = false;
        if (!bl7) {
            Collection<void> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl10 = false;
            Iterable $i$f$flatMapTo2 = candidates2;
            String string = "duplicate Schema : ";
            boolean $i$f$map = false;
            void var15_26 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl11 = false;
                void var23_34 = it;
                collection.add(var23_34);
            }
            collection = (List)destination$iv$iv2;
            String string2 = Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            throw new MojoExecutionException(string2);
        }
        return (File)CollectionsKt.firstOrNull((List)candidates2);
    }
}

