/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin;

import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.AdapterInitializer;
import com.apollographql.apollo3.compiler.ApolloCompiler;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.ExpressionAdapterInitializer;
import com.apollographql.apollo3.compiler.JavaNullable;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.Options;
import com.apollographql.apollo3.compiler.PackageNameGenerator;
import com.apollographql.apollo3.compiler.ScalarInfo;
import com.apollographql.apollo3.compiler.TargetLanguage;
import com.apollographql.apollo3.compiler.introspection.Introspection_to_schemaKt;
import com.github.aoudiamoncef.apollo.plugin.config.CompilationUnit;
import com.github.aoudiamoncef.apollo.plugin.config.CompilerParams;
import com.github.aoudiamoncef.apollo.plugin.config.Introspection;
import com.github.aoudiamoncef.apollo.plugin.config.ScalarMapping;
import com.github.aoudiamoncef.apollo.plugin.config.Service;
import com.github.aoudiamoncef.apollo.plugin.util.ConfigUtils;
import com.github.aoudiamoncef.apollo.plugin.util.SchemaDownloader;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/GraphQLClientMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "project", "Lorg/apache/maven/project/MavenProject;", "services", "", "", "Lcom/github/aoudiamoncef/apollo/plugin/config/Service;", "skip", "", "execute", "", "apollo-client-maven-plugin"})
@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
@SourceDebugExtension(value={"SMAP\nGraphQLClientMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLClientMojo.kt\ncom/github/aoudiamoncef/apollo/plugin/GraphQLClientMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,205:1\n1855#2:206\n1549#2:208\n1620#2,3:209\n1238#2,4:214\n1856#2:218\n1#3:207\n442#4:212\n392#4:213\n*S KotlinDebug\n*F\n+ 1 GraphQLClientMojo.kt\ncom/github/aoudiamoncef/apollo/plugin/GraphQLClientMojo\n*L\n66#1:206\n141#1:208\n141#1:209,3\n144#1:214,4\n66#1:218\n144#1:212\n144#1:213\n*E\n"})
public final class GraphQLClientMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private final boolean skip;
    @Parameter
    private Map<String, Service> services;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException {
        long start = System.nanoTime();
        if (this.skip) {
            this.getLog().info((CharSequence)"Apollo GraphQL Client code generation skipping execution because skip option is true");
            return;
        }
        if (this.services == null) {
            this.getLog().error((CharSequence)"Apollo GraphQL Client code generation failed because of wrong settings");
        }
        this.getLog().info((CharSequence)"Apollo GraphQL Client code generation task started");
        Map<String, Service> map = this.services;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"services");
            map = null;
        }
        Iterable $this$forEach$iv = map.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String generatedSourcePath;
            File file;
            File file2;
            Map.Entry entry;
            void $this$mapValuesTo$iv$iv;
            Schema $this$mapValues$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            OperationOutputGenerator.Default default_;
            Object graphqlFiles;
            PathMatcher graphqlMatcher;
            PathMatcher schemaMatcher;
            Object object3;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            if (!((Service)it.getValue()).getEnabled$apollo_client_maven_plugin()) {
                this.getLog().info((CharSequence)("Skipping generation of service: " + (String)it.getKey() + " because enabled option is false"));
                continue;
            }
            MavenProject mavenProject = this.project;
            if (mavenProject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject = null;
            }
            Service service = ConfigUtils.INSTANCE.checkService$apollo_client_maven_plugin(mavenProject, (String)it.getKey(), (Service)it.getValue());
            MavenProject mavenProject2 = this.project;
            if (mavenProject2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject2 = null;
            }
            CompilationUnit compilationUnit = ConfigUtils.INSTANCE.checkCompilationUnit$apollo_client_maven_plugin(mavenProject2, (String)it.getKey(), service.getCompilationUnit$apollo_client_maven_plugin());
            MavenProject mavenProject3 = this.project;
            if (mavenProject3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject3 = null;
            }
            CompilerParams compilerParams = ConfigUtils.INSTANCE.checkCompilerParams$apollo_client_maven_plugin(mavenProject3, service, compilationUnit.getCompilerParams$apollo_client_maven_plugin());
            MavenProject mavenProject4 = this.project;
            if (mavenProject4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject4 = null;
            }
            Introspection introspection = ConfigUtils.INSTANCE.checkIntrospection$apollo_client_maven_plugin(mavenProject4, service);
            this.getLog().info((CharSequence)("Generating service: " + (String)it.getKey()));
            if (introspection.getEnabled$apollo_client_maven_plugin()) {
                this.getLog().info((CharSequence)("Automatically generating introspection file from: " + introspection.getEndpointUrl$apollo_client_maven_plugin()));
                File schema = introspection.getSchemaFile$apollo_client_maven_plugin();
                boolean bl2 = false;
                OkHttpClient okHttpClient = SchemaDownloader.INSTANCE.newOkHttpClient(introspection.getConnectTimeoutSeconds$apollo_client_maven_plugin(), introspection.getReadTimeoutSeconds$apollo_client_maven_plugin(), introspection.getWriteTimeoutSeconds$apollo_client_maven_plugin(), introspection.getUseSelfSignedCertificat$apollo_client_maven_plugin(), introspection.getUseGzip$apollo_client_maven_plugin());
                if (((CharSequence)introspection.getEndpointUrl$apollo_client_maven_plugin()).length() > 0) {
                    SchemaDownloader schemaDownloader = SchemaDownloader.INSTANCE;
                    Intrinsics.checkNotNull((Object)schema, (String)"null cannot be cast to non-null type java.io.File");
                    File file3 = schema;
                    String string = introspection.getEndpointUrl$apollo_client_maven_plugin();
                    object3 = introspection.getHeaders$apollo_client_maven_plugin();
                    boolean bl3 = introspection.getPrettyPrint$apollo_client_maven_plugin();
                    schemaDownloader.downloadIntrospection(string, file3, (Map<String, String>)object3, bl3, okHttpClient);
                } else if (((CharSequence)introspection.getGraph$apollo_client_maven_plugin()).length() > 0) {
                    String string = introspection.getGraph$apollo_client_maven_plugin();
                    Intrinsics.checkNotNull((Object)schema, (String)"null cannot be cast to non-null type java.io.File");
                    SchemaDownloader.INSTANCE.downloadRegistry(string, schema, introspection.getKey$apollo_client_maven_plugin(), introspection.getGraphVariant$apollo_client_maven_plugin(), introspection.getPrettyPrint$apollo_client_maven_plugin(), okHttpClient);
                }
            }
            this.getLog().info((CharSequence)"Read schema file");
            File file4 = service.getSourceFolder$apollo_client_maven_plugin();
            Intrinsics.checkNotNull((Object)file4, (String)"null cannot be cast to non-null type java.io.File");
            Set<File> sourceSetFiles = ConfigUtils.INSTANCE.getSourceSetFiles$apollo_client_maven_plugin(file4, service.getIncludes$apollo_client_maven_plugin(), service.getExcludes$apollo_client_maven_plugin());
            Intrinsics.checkNotNullExpressionValue((Object)FileSystems.getDefault().getPathMatcher("glob:**.{json,sdl,graphqls}"), (String)"getDefault().getPathMatc\u2026:**.{json,sdl,graphqls}\")");
            Set<File> directories = ConfigUtils.INSTANCE.findFilesByMatcher$apollo_client_maven_plugin(sourceSetFiles, schemaMatcher);
            MavenProject mavenProject5 = this.project;
            if (mavenProject5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject5 = null;
            }
            File resolveSchema2 = ConfigUtils.INSTANCE.resolveSchema$apollo_client_maven_plugin(mavenProject5, service.getSchemaPath$apollo_client_maven_plugin(), directories, sourceSetFiles);
            this.getLog().info((CharSequence)"Read querie(s)/fragment(s) files");
            Intrinsics.checkNotNullExpressionValue((Object)FileSystems.getDefault().getPathMatcher("glob:**.{graphql,gql,graphqls}"), (String)"getDefault().getPathMatc\u2026.{graphql,gql,graphqls}\")");
            Object set = object3 = ConfigUtils.INSTANCE.findFilesByMatcher$apollo_client_maven_plugin(sourceSetFiles, graphqlMatcher);
            boolean bl4 = false;
            if ((!((Collection)set).isEmpty() ? object3 : null) == null) {
                throw new MojoExecutionException("No querie(s)/fragment(s) found");
            }
            graphqlFiles = graphqlFiles;
            if (((CharSequence)compilerParams.getOperationIdGeneratorClass$apollo_client_maven_plugin()).length() == 0) {
                default_ = new OperationOutputGenerator.Default((OperationIdGenerator)OperationIdGenerator.Sha256.INSTANCE);
            } else {
                Object obj = Class.forName(compilerParams.getOperationIdGeneratorClass$apollo_client_maven_plugin()).newInstance();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.apollographql.apollo3.compiler.OperationIdGenerator");
                OperationIdGenerator operationIdGenerator = (OperationIdGenerator)obj;
                default_ = new OperationOutputGenerator.Default(operationIdGenerator);
            }
            OperationOutputGenerator.Default operationOutputGenerator = default_;
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)compilerParams.getMetadataFiles$apollo_client_maven_plugin());
            boolean $i$f$map22 = false;
            Object object4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                object2 = (File)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                object.add(ApolloMetadata.Companion.readFrom((File)it2).getCompilerMetadata());
            }
            List metadata = (List)destination$iv$iv;
            Map<String, ScalarMapping> $i$f$map22 = compilerParams.getScalarsMapping();
            boolean $i$f$mapValues = false;
            destination$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void scalarMapping;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl6 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map2;
                boolean bl7 = false;
                String expression = ((ScalarMapping)scalarMapping.getValue()).getExpression$apollo_client_maven_plugin();
                ScalarInfo scalarInfo = expression == null ? new ScalarInfo(((ScalarMapping)scalarMapping.getValue()).getTargetName$apollo_client_maven_plugin(), null, 2, null) : new ScalarInfo(((ScalarMapping)scalarMapping.getValue()).getTargetName$apollo_client_maven_plugin(), (AdapterInitializer)new ExpressionAdapterInitializer(expression));
                object.put(k, scalarInfo);
            }
            Map scalarMapping = destination$iv$iv2;
            File file5 = resolveSchema2;
            Intrinsics.checkNotNull((Object)file5);
            $this$mapValues$iv = Introspection_to_schemaKt.toSchema((File)file5);
            File file6 = compilationUnit.getOutputDirectory$apollo_client_maven_plugin();
            Intrinsics.checkNotNull((Object)file6, (String)"null cannot be cast to non-null type java.io.File");
            object4 = file6;
            Intrinsics.checkNotNull((Object)compilationUnit.getTestDirectory$apollo_client_maven_plugin(), (String)"null cannot be cast to non-null type java.io.File");
            Intrinsics.checkNotNull((Object)compilationUnit.getDebugDirectory$apollo_client_maven_plugin(), (String)"null cannot be cast to non-null type java.io.File");
            String string = compilerParams.getSchemaPackageName$apollo_client_maven_plugin();
            String string2 = compilerParams.getPackageName$apollo_client_maven_plugin();
            Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
            PackageNameGenerator.Flat flat = new PackageNameGenerator.Flat(string2);
            object2 = compilerParams.getAlwaysGenerateTypesMatching$apollo_client_maven_plugin();
            String string3 = compilerParams.getCodegenModels$apollo_client_maven_plugin().getLabel();
            boolean bl8 = compilerParams.getFlattenModels$apollo_client_maven_plugin();
            boolean bl9 = compilerParams.getUseSemanticNaming$apollo_client_maven_plugin();
            boolean bl10 = compilerParams.getWarnOnDeprecatedUsages$apollo_client_maven_plugin();
            boolean bl11 = compilerParams.getFailOnWarnings$apollo_client_maven_plugin();
            entry = compilerParams.getLogger$apollo_client_maven_plugin();
            boolean bl12 = compilerParams.getGenerateAsInternal$apollo_client_maven_plugin();
            boolean bl13 = compilerParams.getGenerateFilterNotNull$apollo_client_maven_plugin();
            boolean bl14 = compilerParams.getGenerateFragmentImplementations$apollo_client_maven_plugin();
            boolean bl15 = compilerParams.getGenerateResponseFields$apollo_client_maven_plugin();
            boolean bl16 = compilerParams.getGenerateQueryDocument$apollo_client_maven_plugin();
            boolean bl17 = compilerParams.getGenerateSchema$apollo_client_maven_plugin();
            TargetLanguage targetLanguage = compilerParams.getTargetLanguage$apollo_client_maven_plugin();
            boolean bl18 = compilerParams.getGenerateTestBuilders$apollo_client_maven_plugin();
            boolean bl19 = compilerParams.getGenerateModelBuilders$apollo_client_maven_plugin();
            boolean bl20 = compilerParams.getGenerateDataBuilders$apollo_client_maven_plugin();
            JavaNullable javaNullable = compilerParams.getNullableFieldStyle$apollo_client_maven_plugin();
            List<String> list = compilerParams.getSealedClassesForEnumsMatching$apollo_client_maven_plugin();
            boolean bl21 = compilerParams.getGenerateOptionalOperationVariables$apollo_client_maven_plugin();
            ApolloCompiler.INSTANCE.write(new Options((Set)graphqlFiles, $this$mapValues$iv, (File)object4, file2, file, null, null, string, false, (PackageNameGenerator)flat, (Set)object2, (OperationOutputGenerator)operationOutputGenerator, metadata, targetLanguage, scalarMapping, string3, bl8, bl9, bl10, bl11, (ApolloCompiler.Logger)entry, bl12, bl13, bl14, bl15, bl16, bl17, null, bl18, bl20, bl19, list, null, bl21, false, null, null, false, false, javaNullable, false, null, null, 134218080, 1917, null));
            if (service.getAddSourceRoot$apollo_client_maven_plugin()) {
                File file7 = compilationUnit.getOutputDirectory$apollo_client_maven_plugin();
                generatedSourcePath = file7 != null ? file7.getCanonicalPath() : null;
                this.getLog().info((CharSequence)("Add the compiled sources from " + generatedSourcePath + " to project root"));
                MavenProject mavenProject6 = this.project;
                if (mavenProject6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    mavenProject6 = null;
                }
                mavenProject6.addCompileSourceRoot(generatedSourcePath);
            }
            if (!service.getAddTestSourceRoot$apollo_client_maven_plugin()) continue;
            File file8 = compilationUnit.getOutputDirectory$apollo_client_maven_plugin();
            generatedSourcePath = file8 != null ? file8.getCanonicalPath() : null;
            this.getLog().info((CharSequence)("Add the test compiled sources from " + generatedSourcePath + " to project root"));
            MavenProject mavenProject7 = this.project;
            if (mavenProject7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                mavenProject7 = null;
            }
            mavenProject7.addTestCompileSourceRoot(generatedSourcePath);
        }
        this.getLog().info((CharSequence)"Apollo GraphQL Client code generation task finished");
        long finish = System.nanoTime();
        double timeElapsed = (double)(finish - start) / (double)1000000000;
        Log log = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Total time: ");
        String string = "%.3f";
        Object[] objectArray = new Object[]{timeElapsed};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        log.info((CharSequence)stringBuilder.append(string4).append(" s").toString());
    }
}

