/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenMaEmbeddedService;
import me.chanjar.weixin.open.bean.result.WxOpenMaEmbeddedListResult;
import org.apache.commons.lang3.StringUtils;

public class WxOpenMaEmbeddedServiceImpl
implements WxOpenMaEmbeddedService {
    private final WxMaService wxMaService;

    @Override
    public void addEmbedded(String embeddedAppId, String applyReason) throws WxErrorException {
        String response;
        WxError wxError;
        JsonObject params = new JsonObject();
        params.addProperty("appid", embeddedAppId);
        if (StringUtils.isNotBlank((CharSequence)applyReason)) {
            params.addProperty("apply_reason", applyReason);
        }
        if ((wxError = WxError.fromJson((String)(response = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/wxaembedded/add_embedded", params)), (WxType)WxType.MiniApp)).getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public void deleteEmbedded(String embeddedAppId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("appid", embeddedAppId);
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/wxaembedded/del_embedded", params);
        WxError wxError = WxError.fromJson((String)response, (WxType)WxType.MiniApp);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public WxOpenMaEmbeddedListResult getEmbeddedList() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/wxaembedded/get_list", null);
        WxError wxError = WxError.fromJson((String)response, (WxType)WxType.MiniApp);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return (WxOpenMaEmbeddedListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaEmbeddedListResult.class);
    }

    @Override
    public void deleteAuthorizedEmbedded(String embeddedAppId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("appid", embeddedAppId);
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/wxaembedded/del_authorize", params);
        WxError wxError = WxError.fromJson((String)response, (WxType)WxType.MiniApp);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    @Override
    public WxOpenMaEmbeddedListResult getOwnList() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/wxaembedded/get_own_list?num=1000", null);
        WxError wxError = WxError.fromJson((String)response, (WxType)WxType.MiniApp);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return (WxOpenMaEmbeddedListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaEmbeddedListResult.class);
    }

    @Override
    public WxOpenMaEmbeddedListResult getOwnList(Integer start, Integer num) throws WxErrorException {
        String response;
        WxError wxError;
        if (null == start) {
            start = 0;
        }
        if (null == num) {
            num = 10;
        }
        if (num > 1000) {
            num = 1000;
        }
        if ((wxError = WxError.fromJson((String)(response = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/wxaembedded/get_own_list?start=" + start + "&num=" + num, null)), (WxType)WxType.MiniApp)).getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
        return (WxOpenMaEmbeddedListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaEmbeddedListResult.class);
    }

    @Override
    public void setAuthorizedEmbedded(Integer flag) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("flag", (Number)flag);
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/wxaembedded/set_authorize", params);
        WxError wxError = WxError.fromJson((String)response, (WxType)WxType.MiniApp);
        if (wxError.getErrorCode() != 0) {
            throw new WxErrorException(wxError);
        }
    }

    public WxOpenMaEmbeddedServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

