/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.util.WxOpenCryptUtil;
import me.chanjar.weixin.open.util.xml.XStreamTransformer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="xml")
public class WxOpenXmlMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WxOpenXmlMessage.class);
    private static final long serialVersionUID = -5641769554709507771L;
    @XStreamAlias(value="AppId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String appId;
    @XStreamAlias(value="CreateTime")
    private Long createTime;
    @XStreamAlias(value="InfoType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String infoType;
    @XStreamAlias(value="ComponentVerifyTicket")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String componentVerifyTicket;
    @XStreamAlias(value="AuthorizerAppid")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizerAppid;
    @XStreamAlias(value="AuthorizationCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizationCode;
    @XStreamAlias(value="AuthorizationCodeExpiredTime")
    private Long authorizationCodeExpiredTime;
    @XStreamAlias(value="PreAuthCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String preAuthCode;
    @XStreamAlias(value="appid")
    private String subAppId;
    @XStreamAlias(value="status")
    private int status;
    @XStreamAlias(value="auth_code")
    private String authCode;
    @XStreamAlias(value="msg")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msg;
    @XStreamAlias(value="info")
    private Info info = new Info();
    @XStreamAlias(value="taskid")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String taskId;
    @XStreamAlias(value="task_status")
    private Integer taskStatus;
    @XStreamAlias(value="apply_status")
    private Integer applyStatus;
    @XStreamAlias(value="message")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String message;
    @XStreamAlias(value="dispatch_info")
    private DispatchInfo dispatchInfo;
    @XStreamAlias(value="expired")
    private Long expired;
    @XStreamAlias(value="task_id")
    private String IcpVerifyTaskId;
    @XStreamAlias(value="verify_appid")
    private String verifyAppId;
    @XStreamAlias(value="result")
    private Integer result;
    @XStreamAlias(value="along_with_auth_result")
    private Integer alongWithAuthResult;
    @XStreamAlias(value="authorizer_appid")
    private String beianAuthorizerAppId;
    @XStreamAlias(value="beian_status")
    private Integer beianStatus;
    @XStreamAlias(value="procedure_id")
    private String procedureId;
    @XStreamAlias(value="procedure_status")
    private Integer procedureStatus;
    private String context;

    @Deprecated
    public String getRegistAppId() {
        return this.subAppId;
    }

    @Deprecated
    public void setRegistAppId(String value) {
        this.subAppId = value;
    }

    public static String wxMpOutXmlMessageToEncryptedXml(WxMpXmlOutMessage message, WxOpenConfigStorage wxOpenConfigStorage) {
        String plainXml = message.toXml();
        WxOpenCryptUtil pc = new WxOpenCryptUtil(wxOpenConfigStorage);
        return pc.encrypt(plainXml);
    }

    public static WxOpenXmlMessage fromXml(String xml) {
        xml = xml.replace("</PicList><PicList>", "");
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, xml);
    }

    public static WxOpenXmlMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, is);
    }

    public static WxOpenXmlMessage fromEncryptedXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decryptXml(msgSignature, timestamp, nonce, encryptedXml);
        log.debug("\u89e3\u5bc6\u540e\u7684\u539f\u59cbxml\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)plainText);
        WxOpenXmlMessage wxOpenXmlMessage = WxOpenXmlMessage.fromXml(plainText);
        wxOpenXmlMessage.setContext(plainText);
        return wxOpenXmlMessage;
    }

    public static WxMpXmlMessage fromEncryptedMpXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decryptXml(msgSignature, timestamp, nonce, encryptedXml);
        return WxMpXmlMessage.fromXml((String)plainText);
    }

    public static WxOpenXmlMessage fromEncryptedXml(InputStream is, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        try {
            return WxOpenXmlMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxOpenConfigStorage, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public String getComponentVerifyTicket() {
        return this.componentVerifyTicket;
    }

    public String getAuthorizerAppid() {
        return this.authorizerAppid;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public Long getAuthorizationCodeExpiredTime() {
        return this.authorizationCodeExpiredTime;
    }

    public String getPreAuthCode() {
        return this.preAuthCode;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public Info getInfo() {
        return this.info;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Integer getTaskStatus() {
        return this.taskStatus;
    }

    public Integer getApplyStatus() {
        return this.applyStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public DispatchInfo getDispatchInfo() {
        return this.dispatchInfo;
    }

    public Long getExpired() {
        return this.expired;
    }

    public String getIcpVerifyTaskId() {
        return this.IcpVerifyTaskId;
    }

    public String getVerifyAppId() {
        return this.verifyAppId;
    }

    public Integer getResult() {
        return this.result;
    }

    public Integer getAlongWithAuthResult() {
        return this.alongWithAuthResult;
    }

    public String getBeianAuthorizerAppId() {
        return this.beianAuthorizerAppId;
    }

    public Integer getBeianStatus() {
        return this.beianStatus;
    }

    public String getProcedureId() {
        return this.procedureId;
    }

    public Integer getProcedureStatus() {
        return this.procedureStatus;
    }

    public String getContext() {
        return this.context;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.componentVerifyTicket = componentVerifyTicket;
    }

    public void setAuthorizerAppid(String authorizerAppid) {
        this.authorizerAppid = authorizerAppid;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public void setAuthorizationCodeExpiredTime(Long authorizationCodeExpiredTime) {
        this.authorizationCodeExpiredTime = authorizationCodeExpiredTime;
    }

    public void setPreAuthCode(String preAuthCode) {
        this.preAuthCode = preAuthCode;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setApplyStatus(Integer applyStatus) {
        this.applyStatus = applyStatus;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDispatchInfo(DispatchInfo dispatchInfo) {
        this.dispatchInfo = dispatchInfo;
    }

    public void setExpired(Long expired) {
        this.expired = expired;
    }

    public void setIcpVerifyTaskId(String IcpVerifyTaskId) {
        this.IcpVerifyTaskId = IcpVerifyTaskId;
    }

    public void setVerifyAppId(String verifyAppId) {
        this.verifyAppId = verifyAppId;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    public void setAlongWithAuthResult(Integer alongWithAuthResult) {
        this.alongWithAuthResult = alongWithAuthResult;
    }

    public void setBeianAuthorizerAppId(String beianAuthorizerAppId) {
        this.beianAuthorizerAppId = beianAuthorizerAppId;
    }

    public void setBeianStatus(Integer beianStatus) {
        this.beianStatus = beianStatus;
    }

    public void setProcedureId(String procedureId) {
        this.procedureId = procedureId;
    }

    public void setProcedureStatus(Integer procedureStatus) {
        this.procedureStatus = procedureStatus;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxOpenXmlMessage)) {
            return false;
        }
        WxOpenXmlMessage other = (WxOpenXmlMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        Long other$authorizationCodeExpiredTime = other.getAuthorizationCodeExpiredTime();
        if (this$authorizationCodeExpiredTime == null ? other$authorizationCodeExpiredTime != null : !((Object)this$authorizationCodeExpiredTime).equals(other$authorizationCodeExpiredTime)) {
            return false;
        }
        Integer this$taskStatus = this.getTaskStatus();
        Integer other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)this$taskStatus).equals(other$taskStatus)) {
            return false;
        }
        Integer this$applyStatus = this.getApplyStatus();
        Integer other$applyStatus = other.getApplyStatus();
        if (this$applyStatus == null ? other$applyStatus != null : !((Object)this$applyStatus).equals(other$applyStatus)) {
            return false;
        }
        Long this$expired = this.getExpired();
        Long other$expired = other.getExpired();
        if (this$expired == null ? other$expired != null : !((Object)this$expired).equals(other$expired)) {
            return false;
        }
        Integer this$result = this.getResult();
        Integer other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        Integer this$alongWithAuthResult = this.getAlongWithAuthResult();
        Integer other$alongWithAuthResult = other.getAlongWithAuthResult();
        if (this$alongWithAuthResult == null ? other$alongWithAuthResult != null : !((Object)this$alongWithAuthResult).equals(other$alongWithAuthResult)) {
            return false;
        }
        Integer this$beianStatus = this.getBeianStatus();
        Integer other$beianStatus = other.getBeianStatus();
        if (this$beianStatus == null ? other$beianStatus != null : !((Object)this$beianStatus).equals(other$beianStatus)) {
            return false;
        }
        Integer this$procedureStatus = this.getProcedureStatus();
        Integer other$procedureStatus = other.getProcedureStatus();
        if (this$procedureStatus == null ? other$procedureStatus != null : !((Object)this$procedureStatus).equals(other$procedureStatus)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$infoType = this.getInfoType();
        String other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !this$infoType.equals(other$infoType)) {
            return false;
        }
        String this$componentVerifyTicket = this.getComponentVerifyTicket();
        String other$componentVerifyTicket = other.getComponentVerifyTicket();
        if (this$componentVerifyTicket == null ? other$componentVerifyTicket != null : !this$componentVerifyTicket.equals(other$componentVerifyTicket)) {
            return false;
        }
        String this$authorizerAppid = this.getAuthorizerAppid();
        String other$authorizerAppid = other.getAuthorizerAppid();
        if (this$authorizerAppid == null ? other$authorizerAppid != null : !this$authorizerAppid.equals(other$authorizerAppid)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        String this$preAuthCode = this.getPreAuthCode();
        String other$preAuthCode = other.getPreAuthCode();
        if (this$preAuthCode == null ? other$preAuthCode != null : !this$preAuthCode.equals(other$preAuthCode)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        DispatchInfo this$dispatchInfo = this.getDispatchInfo();
        DispatchInfo other$dispatchInfo = other.getDispatchInfo();
        if (this$dispatchInfo == null ? other$dispatchInfo != null : !((Object)this$dispatchInfo).equals(other$dispatchInfo)) {
            return false;
        }
        String this$IcpVerifyTaskId = this.getIcpVerifyTaskId();
        String other$IcpVerifyTaskId = other.getIcpVerifyTaskId();
        if (this$IcpVerifyTaskId == null ? other$IcpVerifyTaskId != null : !this$IcpVerifyTaskId.equals(other$IcpVerifyTaskId)) {
            return false;
        }
        String this$verifyAppId = this.getVerifyAppId();
        String other$verifyAppId = other.getVerifyAppId();
        if (this$verifyAppId == null ? other$verifyAppId != null : !this$verifyAppId.equals(other$verifyAppId)) {
            return false;
        }
        String this$beianAuthorizerAppId = this.getBeianAuthorizerAppId();
        String other$beianAuthorizerAppId = other.getBeianAuthorizerAppId();
        if (this$beianAuthorizerAppId == null ? other$beianAuthorizerAppId != null : !this$beianAuthorizerAppId.equals(other$beianAuthorizerAppId)) {
            return false;
        }
        String this$procedureId = this.getProcedureId();
        String other$procedureId = other.getProcedureId();
        if (this$procedureId == null ? other$procedureId != null : !this$procedureId.equals(other$procedureId)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxOpenXmlMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        result = result * 59 + ($authorizationCodeExpiredTime == null ? 43 : ((Object)$authorizationCodeExpiredTime).hashCode());
        Integer $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)$taskStatus).hashCode());
        Integer $applyStatus = this.getApplyStatus();
        result = result * 59 + ($applyStatus == null ? 43 : ((Object)$applyStatus).hashCode());
        Long $expired = this.getExpired();
        result = result * 59 + ($expired == null ? 43 : ((Object)$expired).hashCode());
        Integer $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        Integer $alongWithAuthResult = this.getAlongWithAuthResult();
        result = result * 59 + ($alongWithAuthResult == null ? 43 : ((Object)$alongWithAuthResult).hashCode());
        Integer $beianStatus = this.getBeianStatus();
        result = result * 59 + ($beianStatus == null ? 43 : ((Object)$beianStatus).hashCode());
        Integer $procedureStatus = this.getProcedureStatus();
        result = result * 59 + ($procedureStatus == null ? 43 : ((Object)$procedureStatus).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : $infoType.hashCode());
        String $componentVerifyTicket = this.getComponentVerifyTicket();
        result = result * 59 + ($componentVerifyTicket == null ? 43 : $componentVerifyTicket.hashCode());
        String $authorizerAppid = this.getAuthorizerAppid();
        result = result * 59 + ($authorizerAppid == null ? 43 : $authorizerAppid.hashCode());
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        String $preAuthCode = this.getPreAuthCode();
        result = result * 59 + ($preAuthCode == null ? 43 : $preAuthCode.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        DispatchInfo $dispatchInfo = this.getDispatchInfo();
        result = result * 59 + ($dispatchInfo == null ? 43 : ((Object)$dispatchInfo).hashCode());
        String $IcpVerifyTaskId = this.getIcpVerifyTaskId();
        result = result * 59 + ($IcpVerifyTaskId == null ? 43 : $IcpVerifyTaskId.hashCode());
        String $verifyAppId = this.getVerifyAppId();
        result = result * 59 + ($verifyAppId == null ? 43 : $verifyAppId.hashCode());
        String $beianAuthorizerAppId = this.getBeianAuthorizerAppId();
        result = result * 59 + ($beianAuthorizerAppId == null ? 43 : $beianAuthorizerAppId.hashCode());
        String $procedureId = this.getProcedureId();
        result = result * 59 + ($procedureId == null ? 43 : $procedureId.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public String toString() {
        return "WxOpenXmlMessage(appId=" + this.getAppId() + ", createTime=" + this.getCreateTime() + ", infoType=" + this.getInfoType() + ", componentVerifyTicket=" + this.getComponentVerifyTicket() + ", authorizerAppid=" + this.getAuthorizerAppid() + ", authorizationCode=" + this.getAuthorizationCode() + ", authorizationCodeExpiredTime=" + this.getAuthorizationCodeExpiredTime() + ", preAuthCode=" + this.getPreAuthCode() + ", subAppId=" + this.getSubAppId() + ", status=" + this.getStatus() + ", authCode=" + this.getAuthCode() + ", msg=" + this.getMsg() + ", info=" + this.getInfo() + ", taskId=" + this.getTaskId() + ", taskStatus=" + this.getTaskStatus() + ", applyStatus=" + this.getApplyStatus() + ", message=" + this.getMessage() + ", dispatchInfo=" + this.getDispatchInfo() + ", expired=" + this.getExpired() + ", IcpVerifyTaskId=" + this.getIcpVerifyTaskId() + ", verifyAppId=" + this.getVerifyAppId() + ", result=" + this.getResult() + ", alongWithAuthResult=" + this.getAlongWithAuthResult() + ", beianAuthorizerAppId=" + this.getBeianAuthorizerAppId() + ", beianStatus=" + this.getBeianStatus() + ", procedureId=" + this.getProcedureId() + ", procedureStatus=" + this.getProcedureStatus() + ", context=" + this.getContext() + ")";
    }

    public static class DispatchInfo {
        @XStreamConverter(value=XStreamCDataConverter.class)
        @XStreamAlias(value="provider")
        private String provider;
        @XStreamConverter(value=XStreamCDataConverter.class)
        @XStreamAlias(value="contact")
        private String contact;
        @XStreamAlias(value="dispatch_time")
        private Long dispatchTime;

        public String getProvider() {
            return this.provider;
        }

        public String getContact() {
            return this.contact;
        }

        public Long getDispatchTime() {
            return this.dispatchTime;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public void setDispatchTime(Long dispatchTime) {
            this.dispatchTime = dispatchTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DispatchInfo)) {
                return false;
            }
            DispatchInfo other = (DispatchInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$dispatchTime = this.getDispatchTime();
            Long other$dispatchTime = other.getDispatchTime();
            if (this$dispatchTime == null ? other$dispatchTime != null : !((Object)this$dispatchTime).equals(other$dispatchTime)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            String this$contact = this.getContact();
            String other$contact = other.getContact();
            return !(this$contact == null ? other$contact != null : !this$contact.equals(other$contact));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DispatchInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $dispatchTime = this.getDispatchTime();
            result = result * 59 + ($dispatchTime == null ? 43 : ((Object)$dispatchTime).hashCode());
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            String $contact = this.getContact();
            result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
            return result;
        }

        public String toString() {
            return "WxOpenXmlMessage.DispatchInfo(provider=" + this.getProvider() + ", contact=" + this.getContact() + ", dispatchTime=" + this.getDispatchTime() + ")";
        }
    }

    @XStreamAlias(value="info")
    public static class Info
    implements Serializable {
        private static final long serialVersionUID = 7706235740094081194L;
        @XStreamAlias(value="name")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String name;
        @XStreamAlias(value="code")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String code;
        @XStreamAlias(value="code_type")
        private int codeType;
        @XStreamAlias(value="legal_persona_wechat")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String legalPersonaWechat;
        @XStreamAlias(value="legal_persona_name")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String legalPersonaName;
        @XStreamAlias(value="component_phone")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String componentPhone;
        @XStreamAlias(value="wxuser")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String wxuser;
        @XStreamAlias(value="idname")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String idname;
        @XStreamAlias(value="unique_id")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String uniqueId;

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public int getCodeType() {
            return this.codeType;
        }

        public String getLegalPersonaWechat() {
            return this.legalPersonaWechat;
        }

        public String getLegalPersonaName() {
            return this.legalPersonaName;
        }

        public String getComponentPhone() {
            return this.componentPhone;
        }

        public String getWxuser() {
            return this.wxuser;
        }

        public String getIdname() {
            return this.idname;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setCodeType(int codeType) {
            this.codeType = codeType;
        }

        public void setLegalPersonaWechat(String legalPersonaWechat) {
            this.legalPersonaWechat = legalPersonaWechat;
        }

        public void setLegalPersonaName(String legalPersonaName) {
            this.legalPersonaName = legalPersonaName;
        }

        public void setComponentPhone(String componentPhone) {
            this.componentPhone = componentPhone;
        }

        public void setWxuser(String wxuser) {
            this.wxuser = wxuser;
        }

        public void setIdname(String idname) {
            this.idname = idname;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCodeType() != other.getCodeType()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$legalPersonaWechat = this.getLegalPersonaWechat();
            String other$legalPersonaWechat = other.getLegalPersonaWechat();
            if (this$legalPersonaWechat == null ? other$legalPersonaWechat != null : !this$legalPersonaWechat.equals(other$legalPersonaWechat)) {
                return false;
            }
            String this$legalPersonaName = this.getLegalPersonaName();
            String other$legalPersonaName = other.getLegalPersonaName();
            if (this$legalPersonaName == null ? other$legalPersonaName != null : !this$legalPersonaName.equals(other$legalPersonaName)) {
                return false;
            }
            String this$componentPhone = this.getComponentPhone();
            String other$componentPhone = other.getComponentPhone();
            if (this$componentPhone == null ? other$componentPhone != null : !this$componentPhone.equals(other$componentPhone)) {
                return false;
            }
            String this$wxuser = this.getWxuser();
            String other$wxuser = other.getWxuser();
            if (this$wxuser == null ? other$wxuser != null : !this$wxuser.equals(other$wxuser)) {
                return false;
            }
            String this$idname = this.getIdname();
            String other$idname = other.getIdname();
            if (this$idname == null ? other$idname != null : !this$idname.equals(other$idname)) {
                return false;
            }
            String this$uniqueId = this.getUniqueId();
            String other$uniqueId = other.getUniqueId();
            return !(this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Info;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCodeType();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $legalPersonaWechat = this.getLegalPersonaWechat();
            result = result * 59 + ($legalPersonaWechat == null ? 43 : $legalPersonaWechat.hashCode());
            String $legalPersonaName = this.getLegalPersonaName();
            result = result * 59 + ($legalPersonaName == null ? 43 : $legalPersonaName.hashCode());
            String $componentPhone = this.getComponentPhone();
            result = result * 59 + ($componentPhone == null ? 43 : $componentPhone.hashCode());
            String $wxuser = this.getWxuser();
            result = result * 59 + ($wxuser == null ? 43 : $wxuser.hashCode());
            String $idname = this.getIdname();
            result = result * 59 + ($idname == null ? 43 : $idname.hashCode());
            String $uniqueId = this.getUniqueId();
            result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
            return result;
        }

        public String toString() {
            return "WxOpenXmlMessage.Info(name=" + this.getName() + ", code=" + this.getCode() + ", codeType=" + this.getCodeType() + ", legalPersonaWechat=" + this.getLegalPersonaWechat() + ", legalPersonaName=" + this.getLegalPersonaName() + ", componentPhone=" + this.getComponentPhone() + ", wxuser=" + this.getWxuser() + ", idname=" + this.getIdname() + ", uniqueId=" + this.getUniqueId() + ")";
        }
    }
}

