/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import java.io.IOException;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLanguageServer {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLanguageServer.class);
    private Thread runner;
    private volatile boolean shutdown;
    private long parentProcessId;
    private WorkspaceService workspaceService;
    private CamelTextDocumentService textDocumentService;

    public int startServer() {
        this.runner = new Thread((Runnable)new CamelServerRunnable(), "Camel Language Client Watcher");
        this.runner.start();
        return 0;
    }

    protected boolean parentProcessStillRunning() {
        if (this.parentProcessId == 0L) {
            LOGGER.info("Waiting for a client connection...");
        } else {
            LOGGER.info("Checking for client process pid: {}", (Object)this.parentProcessId);
        }
        if (this.parentProcessId == 0L) {
            return true;
        }
        String command = OS.indexOf("win") != -1 ? "cmd /c \"tasklist /FI \"PID eq " + this.parentProcessId + "\" | findstr " + this.parentProcessId + "\"" : "ps -p " + this.parentProcessId;
        try {
            Process process = Runtime.getRuntime().exec(command);
            int processResult = process.waitFor();
            return processResult == 0;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return true;
        }
    }

    public void stopServer() {
        LOGGER.info("Stopping language server");
        if (this.runner != null) {
            this.runner.interrupt();
        } else {
            LOGGER.info("Request to stop the server has been received but it wasn't started.");
        }
    }

    public void shutdownServer() {
        LOGGER.info("Shutting down language server");
        this.shutdown = true;
    }

    protected synchronized long getParentProcessId() {
        return this.parentProcessId;
    }

    protected synchronized void setParentProcessId(long processId) {
        LOGGER.info("Setting client pid to {}", (Object)processId);
        this.parentProcessId = processId;
    }

    public CamelTextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    protected void setTextDocumentService(CamelTextDocumentService textDocumentService) {
        this.textDocumentService = textDocumentService;
    }

    protected WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    protected void setWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    private final class CamelServerRunnable
    implements Runnable {
        private CamelServerRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info("Starting Camel Language Server...");
            while (!AbstractLanguageServer.this.shutdown && AbstractLanguageServer.this.parentProcessStillRunning() && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                LOGGER.info("Camel Language Server - Client vanished...");
            }
        }
    }
}

