/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal;

import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelWorkspaceService
implements WorkspaceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelWorkspaceService.class);
    private SettingsManager settingsManager;

    public CamelWorkspaceService(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        LOGGER.info("SERVER: symbolQuery: {}", (Object)params.getQuery());
        return CompletableFuture.completedFuture(Either.forRight(Collections.emptyList()));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Object settings = params.getSettings();
        this.settingsManager.apply(params);
        LOGGER.info("SERVER: changeConfig: settings -> {}", settings);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        List settings = params.getChanges();
        LOGGER.info("SERVER: changeWatchedFiles: size -> {}", (Object)settings.size());
    }
}

