/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal;

import com.github.cameltooling.lsp.internal.CamelLanguageServer;
import com.github.cameltooling.lsp.internal.websocket.WebSocketRunner;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class Runner {
    static CamelLanguageServer server;
    static WebSocketRunner webSocketRunner;
    private static final String WEBSOCKET_PARAMETER = "--websocket";
    private static final String PORT_PARAMETER = "--port=";
    private static final String HOSTNAME_PARAMETER = "--hostname=";
    private static final String CONTEXTPATH_PARAMETER = "--contextPath=";
    static final String HELP_PARAMETER = "--help";
    static final String HELP_MESSAGE = "`--help` to display this message\n\nWhen launching without parameter, the Language Client can use Standard Input and Ouput to connect to the Camel Language Server.\n\nTo use a websocket connection, the parameter `--websocket` must be provided.\nIf you are using a websocket connection, 3 other parameters are available:\n  `--port=<port>` default value is `8025`\n  `--hostname=<hostname>`, default value `localhost`\n  `--contextPath=<contextPath>`, default value `/`. It must start with a `/`.";

    public static void main(String[] args) {
        List<String> arguments = Arrays.asList(args);
        if (arguments.contains(HELP_PARAMETER)) {
            System.out.println(HELP_MESSAGE);
        } else if (arguments.contains(WEBSOCKET_PARAMETER)) {
            int port = Runner.extractPort(arguments);
            String hostname = Runner.extractHostname(arguments);
            webSocketRunner = new WebSocketRunner();
            String contextPath = Runner.extractContextPath(arguments);
            webSocketRunner.runWebSocketServer(hostname, port, contextPath);
        } else {
            server = new CamelLanguageServer();
            Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)server, (InputStream)System.in, (OutputStream)System.out);
            server.connect((LanguageClient)launcher.getRemoteProxy());
            launcher.startListening();
        }
    }

    private static String extractContextPath(List<String> arguments) {
        return Runner.extractParameterValue(arguments, CONTEXTPATH_PARAMETER);
    }

    private static String extractHostname(List<String> arguments) {
        return Runner.extractParameterValue(arguments, HOSTNAME_PARAMETER);
    }

    private static String extractParameterValue(List<String> arguments, String parameterToExtract) {
        for (String argument : arguments) {
            if (!argument.startsWith(parameterToExtract)) continue;
            return argument.substring(parameterToExtract.length());
        }
        return null;
    }

    private static int extractPort(List<String> arguments) {
        for (String argument : arguments) {
            if (!argument.startsWith(PORT_PARAMETER)) continue;
            String providedPort = argument.substring(PORT_PARAMETER.length());
            try {
                return Integer.parseInt(providedPort);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("The provided port is invalid.", nfe);
            }
        }
        return -1;
    }
}

