/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.catalog.util;

import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelNodeDetailsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelNodeDetailsUtils.class);

    public Range computeRange(CamelNodeDetails camelNodeDetails, TextDocumentItem textDocumentItem) {
        int endLine = this.retrieveEndline(camelNodeDetails, textDocumentItem);
        Position startPosition = new Position(Integer.valueOf(camelNodeDetails.getLineNumber()) - 1, 0);
        Position endPosition = new Position(endLine, new ParserFileHelperUtil().getLine(textDocumentItem, endLine).length());
        return new Range(startPosition, endPosition);
    }

    private int retrieveEndline(CamelNodeDetails camelNodeDetails, TextDocumentItem textDocumentItem) {
        int lineNumberAfter;
        String theLineAfter;
        OptionalInt endLineComputedFromChildren = this.retrieveAllChildrenOutputs(camelNodeDetails).mapToInt(output -> {
            String lineNumberEndAsString = output.getLineNumberEnd();
            if (lineNumberEndAsString != null) {
                try {
                    return Integer.valueOf(lineNumberEndAsString) - 1;
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("The parsing of the file " + camelNodeDetails.getFileName() + " returned an invalid line number end " + lineNumberEndAsString + " for node " + camelNodeDetails.getName(), (Throwable)ex);
                    return 0;
                }
            }
            return 0;
        }).max();
        if (endLineComputedFromChildren.isPresent() && (theLineAfter = new ParserFileHelperUtil().getLine(textDocumentItem, lineNumberAfter = endLineComputedFromChildren.getAsInt() + 1)) != null && theLineAfter.trim().contains(".end()")) {
            return lineNumberAfter;
        }
        return endLineComputedFromChildren.orElse(Integer.valueOf(camelNodeDetails.getLineNumberEnd()) - 1);
    }

    public Stream<CamelNodeDetails> retrieveAllChildrenOutputs(CamelNodeDetails camelNodeDetails) {
        List children = camelNodeDetails.getOutputs();
        if (children != null) {
            return Stream.concat(Stream.of(camelNodeDetails), children.stream().flatMap(this::retrieveAllChildrenOutputs));
        }
        return Stream.of(camelNodeDetails);
    }
}

