/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.codeactions;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModeline;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import com.github.cameltooling.lsp.internal.parser.CamelKModelineParser;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ConvertCamelKPropertyFileModelineRefactorAction {
    public static final String CODE_ACTION_TITLE_CONVERT_PROPERTY_FILE = "Convert deprecated modeline options property-file to property=file: notation";
    private CamelTextDocumentService camelTextDocumentService;

    public ConvertCamelKPropertyFileModelineRefactorAction(CamelTextDocumentService camelTextDocumentService) {
        this.camelTextDocumentService = camelTextDocumentService;
    }

    public Collection<Either<Command, CodeAction>> getCodeActions(CodeActionParams params) {
        int endLine;
        String uri = params.getTextDocument().getUri();
        TextDocumentItem openedDocument = this.camelTextDocumentService.getOpenedDocument(uri);
        int startLine = params.getRange().getStart().getLine();
        if (startLine == (endLine = params.getRange().getEnd().getLine()) && new CamelKModelineParser().isOnCamelKModeline(startLine, openedDocument)) {
            CamelKModeline camelKModeline = new CamelKModeline(new ParserFileHelperUtil().getLine(openedDocument, startLine), openedDocument, startLine);
            ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
            HashMap changes = new HashMap();
            ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
            for (CamelKModelineOption option : camelKModeline.getOptions()) {
                if (!"property-file".equals(option.getOptionName())) continue;
                ICamelKModelineOptionValue optionValue = option.getOptionValue();
                String newText = "property=file:" + (optionValue != null ? optionValue.getValueAsString() : "");
                textEdits.add(new TextEdit(option.getRange(), newText));
            }
            if (!textEdits.isEmpty()) {
                changes.put(uri, textEdits);
                CodeAction codeAction = new CodeAction(CODE_ACTION_TITLE_CONVERT_PROPERTY_FILE);
                codeAction.setKind("refactor");
                codeAction.setEdit(new WorkspaceEdit(changes));
                codeActions.add((Either<Command, CodeAction>)Either.forRight((Object)codeAction));
            }
            return codeActions;
        }
        return Collections.emptyList();
    }
}

