/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentNamePropertyInstance;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;

public class CamelComponentIdsCompletionsFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private String startFilter;
    private CamelComponentNamePropertyInstance camelComponentNamePropertyFileInstance;

    public CamelComponentIdsCompletionsFuture(CamelComponentNamePropertyInstance camelComponentNamePropertyFileInstance, String startFilter) {
        this.camelComponentNamePropertyFileInstance = camelComponentNamePropertyFileInstance;
        this.startFilter = startFilter;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog catalog) {
        return catalog.findComponentNames().stream().map(componentName -> ModelHelper.generateComponentModel(catalog.componentJSonSchema(componentName), true)).map(componentModel -> {
            CompletionItem completionItem = new CompletionItem(componentModel.getScheme());
            completionItem.setDocumentation(componentModel.getDescription());
            CompletionResolverUtils.applyDeprecation(completionItem, componentModel.getDeprecated());
            CompletionResolverUtils.applyTextEditToCompletionItem(this.camelComponentNamePropertyFileInstance, completionItem);
            return completionItem;
        }).filter(FilterPredicateUtils.matchesCompletionFilter(this.startFilter)).collect(Collectors.toList());
    }
}

