/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentPropertyKey;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyValueInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;

public class CamelComponentOptionValuesCompletionsFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private static final String BOOLEAN_TYPE = "boolean";
    private CamelPropertyValueInstance camelPropertyFileValueInstance;
    private String startFilter;

    public CamelComponentOptionValuesCompletionsFuture(CamelPropertyValueInstance camelPropertyFileValueInstance, String startFilter) {
        this.camelPropertyFileValueInstance = camelPropertyFileValueInstance;
        this.startFilter = startFilter;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog camelCatalog) {
        Optional<ComponentOptionModel> endpointModel = this.retrieveEndpointOptionModel(camelCatalog);
        if (endpointModel.isPresent()) {
            ComponentOptionModel endpointOptionModel = endpointModel.get();
            List<String> enums = endpointOptionModel.getEnums();
            if (enums != null && !enums.isEmpty()) {
                return this.computeCompletionForEnums(enums);
            }
            if (BOOLEAN_TYPE.equals(endpointOptionModel.getType())) {
                CompletionItem trueCompletion = new CompletionItem(Boolean.TRUE.toString());
                CompletionResolverUtils.applyTextEditToCompletionItem(this.camelPropertyFileValueInstance, trueCompletion);
                CompletionItem falseCompletion = new CompletionItem(Boolean.FALSE.toString());
                CompletionResolverUtils.applyTextEditToCompletionItem(this.camelPropertyFileValueInstance, falseCompletion);
                Stream<CompletionItem> values = Stream.of(trueCompletion, falseCompletion);
                return values.filter(FilterPredicateUtils.matchesCompletionFilter(this.startFilter)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> computeCompletionForEnums(List<String> enums) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        for (String enumValue : enums) {
            CompletionItem item = new CompletionItem(enumValue);
            CompletionResolverUtils.applyTextEditToCompletionItem(this.camelPropertyFileValueInstance, item);
            completionItems.add(item);
        }
        return completionItems.stream().filter(FilterPredicateUtils.matchesCompletionFilter(this.startFilter)).collect(Collectors.toList());
    }

    private Optional<ComponentOptionModel> retrieveEndpointOptionModel(CamelCatalog camelCatalog) {
        CamelComponentPropertyKey camelComponentPropertyFilekey = this.camelPropertyFileValueInstance.getKey().getCamelComponentPropertyKey();
        if (camelComponentPropertyFilekey != null) {
            String componentId = camelComponentPropertyFilekey.getComponentId();
            String keyName = camelComponentPropertyFilekey.getComponentProperty();
            if (keyName != null) {
                List<ComponentOptionModel> endpointOptions = ModelHelper.generateComponentModel(camelCatalog.componentJSonSchema(componentId), true).getComponentOptions();
                return endpointOptions.stream().filter(endpoint -> keyName.equals(endpoint.getName())).findAny();
            }
        }
        return Optional.empty();
    }
}

