/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.BaseOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamKeyURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import io.fabric8.kubernetes.api.model.AnyType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.v1.kameletspec.Definition;
import org.apache.camel.v1.kameletspec.definition.Properties;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;

public class CamelOptionNamesCompletionsFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private final boolean markdown;
    private CamelUriElementInstance uriElement;
    private String camelComponentName;
    private boolean isProducer;
    private String filterString;
    private int positionInCamelURI;
    private Set<OptionParamURIInstance> alreadyDefinedOptions;
    private KameletsCatalogManager kameletsCatalogManager;

    public CamelOptionNamesCompletionsFuture(CamelUriElementInstance uriElement, String camelComponentName, boolean isProducer, String filterText, int positionInCamelURI, Set<OptionParamURIInstance> alreadyDefinedOptions, KameletsCatalogManager kameletsCatalogManager, boolean markdown) {
        this.uriElement = uriElement;
        this.camelComponentName = camelComponentName;
        this.isProducer = isProducer;
        this.filterString = filterText;
        this.positionInCamelURI = positionInCamelURI;
        this.alreadyDefinedOptions = alreadyDefinedOptions;
        this.kameletsCatalogManager = kameletsCatalogManager;
        this.markdown = markdown;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog catalog) {
        ComponentModel componentModel = ModelHelper.generateComponentModel(catalog.componentJSonSchema(this.camelComponentName), true);
        List<EndpointOptionModel> endpointOptions = componentModel.getEndpointOptions();
        Stream<? extends CompletionItem> endpointOptionsFiltered = this.initialFilter(endpointOptions).map(this.createCompletionItem(CompletionItemKind.Property));
        List<EndpointOptionModel> availableApiProperties = this.uriElement.findAvailableApiProperties(componentModel);
        Stream<? extends CompletionItem> availableApiPropertiesFiltered = this.initialFilter(availableApiProperties).map(this.createCompletionItem(CompletionItemKind.Variable));
        Stream<CompletionItem> kameletProperties = this.retrieveKameletProperties();
        Stream<CompletionItem> twitterGeographySearchProperties = this.retrieveTwitterGeographySearchProperties();
        return Stream.concat(Stream.concat(Stream.concat(endpointOptionsFiltered, availableApiPropertiesFiltered), kameletProperties), twitterGeographySearchProperties).filter(FilterPredicateUtils.removeDuplicatedOptions(this.alreadyDefinedOptions, this.positionInCamelURI)).filter(FilterPredicateUtils.matchesCompletionFilter(this.filterString)).collect(Collectors.toList());
    }

    private Stream<CompletionItem> retrieveTwitterGeographySearchProperties() {
        Stream<CompletionItem> twitterGeographySearchProperties = Stream.empty();
        if ("twitter-search".equals(this.camelComponentName)) {
            return Stream.of(this.createTwitterGeographySearchCompletionItem());
        }
        return twitterGeographySearchProperties;
    }

    private CompletionItem createTwitterGeographySearchCompletionItem() {
        CompletionItem completionItem = new CompletionItem("twitter-search:<keywords>?<geography-search>");
        String documentation = "Perform a Geography Search using the configured metrics.\n\n`?latitude=<value>&longitude=<value>&radius=<value>&distanceMetric=km|mi`\n\nYou need to configure all the following options: latitude, longitude, radius, and distanceMetric.";
        completionItem.setDocumentation(new MarkupContent("markdown", documentation));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        completionItem.setKind(CompletionItemKind.Snippet);
        completionItem.setSortText("1");
        String sep = this.uriElement.getCamelUriInstance().getDslModelHelper().getParametersSeparator();
        completionItem.setInsertText("latitude=${1:latitude}" + sep + "longitude=${2:longitude}" + sep + "radius=${3:radius}" + sep + "distanceMetric=${4|km,mi|}");
        CompletionResolverUtils.applyTextEditToCompletionItem(this.uriElement, completionItem);
        return completionItem;
    }

    private Stream<CompletionItem> retrieveKameletProperties() {
        Definition kameletDefinition;
        Optional<String> kameletTemplateId;
        Stream<CompletionItem> kameletProperties = Stream.empty();
        if ("kamelet".equals(this.camelComponentName) && (kameletTemplateId = this.uriElement.getCamelUriInstance().getComponentAndPathUriElementInstance().getPathParams().stream().filter(pathParam -> pathParam.getPathParamIndex() == 0).map(PathParamURIInstance::getValue).findAny()).isPresent() && (kameletDefinition = this.kameletsCatalogManager.getCatalog().getKameletDefinition(kameletTemplateId.get())) != null) {
            kameletProperties = kameletDefinition.getProperties().entrySet().stream().map(this::createCompletionItem);
        }
        return kameletProperties;
    }

    private CompletionItem createCompletionItem(Map.Entry<String, Properties> property) {
        String propertyName = property.getKey();
        CompletionItem completionItem = new CompletionItem(propertyName);
        Properties schema = property.getValue();
        String insertText = this.computeInsertText(propertyName, schema);
        completionItem.setInsertText(insertText);
        completionItem.setDocumentation(schema.getDescription());
        String type = schema.getType();
        if (type != null) {
            completionItem.setDetail(type);
        }
        CompletionResolverUtils.applyTextEditToCompletionItem(this.uriElement, completionItem);
        return completionItem;
    }

    private String computeInsertText(String propertyName, Properties schema) {
        AnyType defaultValue = schema.get_default();
        String insertText = propertyName + "=";
        if (defaultValue != null && defaultValue.getValue() != null) {
            insertText = insertText + defaultValue.getValue().toString();
        }
        return insertText;
    }

    private Stream<EndpointOptionModel> initialFilter(List<EndpointOptionModel> endpointOptions) {
        return endpointOptions.stream().filter(endpoint -> "parameter".equals(endpoint.getKind())).filter(FilterPredicateUtils.matchesProducerConsumerGroups(this.isProducer));
    }

    private Function<? super BaseOptionModel, ? extends CompletionItem> createCompletionItem(CompletionItemKind kind) {
        return parameter -> {
            CompletionItem completionItem = new CompletionItem(parameter.getName());
            Object insertText = parameter.getName();
            boolean hasValue = false;
            if (this.uriElement instanceof OptionParamKeyURIInstance) {
                OptionParamKeyURIInstance param = (OptionParamKeyURIInstance)this.uriElement;
                boolean bl = hasValue = param.getOptionParamURIInstance().getValue() != null;
            }
            if (!hasValue && parameter.getDefaultValue() != null) {
                insertText = (String)insertText + String.format("=%s", parameter.getDefaultValue());
            }
            completionItem.setInsertText((String)insertText);
            if (this.markdown) {
                completionItem.setDocumentation(this.getMarkupDocumentation((BaseOptionModel)parameter));
            } else {
                completionItem.setDocumentation(this.getDocumentation((BaseOptionModel)parameter));
            }
            completionItem.setDetail(parameter.getJavaType());
            completionItem.setKind(kind);
            this.configureSortTextToHaveApiBasedOptionsBefore(kind, completionItem, (String)insertText);
            CompletionResolverUtils.applyDeprecation(completionItem, parameter.isDeprecated());
            CompletionResolverUtils.applyTextEditToCompletionItem(this.uriElement, completionItem);
            return completionItem;
        };
    }

    private MarkupContent getMarkupDocumentation(BaseOptionModel parameter) {
        String defaultValue;
        StringBuilder doc = new StringBuilder();
        this.addMarkdownIfNotEmpty(doc, "**Group:** ", parameter.getGroup());
        this.addMarkdownIfNotEmpty(doc, "**Required:** ", String.valueOf(parameter.isRequired()));
        List<String> values = parameter.getEnums();
        if (values != null) {
            List italic = values.stream().map(s -> "*" + s + "*").collect(Collectors.toList());
            String value = String.join((CharSequence)", ", italic);
            this.addMarkdownIfNotEmpty(doc, "**Possible values:** ", value);
        }
        if ((defaultValue = String.valueOf(parameter.getDefaultValue())) != null && !defaultValue.isEmpty() && !"null".equals(defaultValue)) {
            this.addMarkdownIfNotEmpty(doc, "**Default value:** ", "*" + defaultValue + "*");
        }
        doc.append("\\\n");
        doc.append(parameter.getDescription());
        return new MarkupContent("markdown", doc.toString());
    }

    private String getDocumentation(BaseOptionModel parameter) {
        StringBuilder doc = new StringBuilder();
        this.addIfNotEmpty(doc, "Group: ", parameter.getGroup());
        this.addIfNotEmpty(doc, "Required: ", String.valueOf(parameter.isRequired()));
        List<String> values = parameter.getEnums();
        if (values != null) {
            String value = String.join((CharSequence)", ", values);
            this.addIfNotEmpty(doc, "Possible values: ", value);
        }
        this.addIfNotEmpty(doc, "Default value: ", String.valueOf(parameter.getDefaultValue()));
        doc.append('\n');
        doc.append(parameter.getDescription());
        return doc.toString();
    }

    private void addIfNotEmpty(StringBuilder description, String key, String value) {
        if (value != null && !value.isEmpty() && !"null".equals(value)) {
            description.append(key);
            description.append(value);
            description.append('\n');
        }
    }

    private void addMarkdownIfNotEmpty(StringBuilder description, String key, String value) {
        if (value != null && !value.isEmpty() && !"null".equals(value)) {
            description.append(key);
            description.append(value);
            description.append("\\\n");
        }
    }

    private void configureSortTextToHaveApiBasedOptionsBefore(CompletionItemKind kind, CompletionItem completionItem, String insertText) {
        if (CompletionItemKind.Variable.equals((Object)kind)) {
            completionItem.setSortText("1-" + insertText);
        }
    }
}

