/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyEntryInstance;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelPropertiesCompletionProcessor {
    private TextDocumentItem textDocumentItem;
    private CompletableFuture<CamelCatalog> camelCatalog;

    public CamelPropertiesCompletionProcessor(TextDocumentItem textDocumentItem, CompletableFuture<CamelCatalog> camelCatalog) {
        this.textDocumentItem = textDocumentItem;
        this.camelCatalog = camelCatalog;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.textDocumentItem != null) {
            String line = new ParserFileHelperUtil().getLine(this.textDocumentItem, position);
            return new CamelPropertyEntryInstance(line, new Position(position.getLine(), 0), this.textDocumentItem).getCompletions(position, this.camelCatalog, settingsManager, kameletsCatalogManager);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }
}

