/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomCompletionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomCompletionProcessor.class);
    private TextDocumentItem textDocumentItem;
    private CompletableFuture<CamelCatalog> camelCatalog;

    public PomCompletionProcessor(TextDocumentItem textDocumentItem, CompletableFuture<CamelCatalog> camelCatalog) {
        this.textDocumentItem = textDocumentItem;
        this.camelCatalog = camelCatalog;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position) {
        ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
        String text = this.textDocumentItem.getText();
        String[] lines = text.split("\\R");
        if (this.isInsideTag(position, lines, "profiles")) {
            completions.add(this.createCamelQuarkusDebugProfileCompletionItem());
        }
        if (this.isInsideTag(position, lines, "dependencies")) {
            try {
                completions.addAll(this.createCamelDependenciesCompletionItems());
            }
            catch (Exception e) {
                LOGGER.warn("Error while computing Camel dependencies for Maven pom", (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(completions);
    }

    private List<CompletionItem> createCamelDependenciesCompletionItems() throws InterruptedException, ExecutionException {
        ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
        List componentNames = this.camelCatalog.get().findComponentNames();
        for (String componentName : componentNames) {
            ComponentModel componentModel = ModelHelper.generateComponentModel(this.camelCatalog.get().componentJSonSchema(componentName), false);
            CompletionItem completionItem = new CompletionItem("Camel dependency for component " + componentModel.getTitle());
            completionItem.setInsertText("<dependency>\n\t<groupId>" + componentModel.getGroupId() + "</groupId>\n\t<artifactId>" + componentModel.getArtifactId() + "</artifactId>\n</dependency>\n");
            CompletionResolverUtils.applyDeprecation(completionItem, componentModel.getDeprecated());
            completions.add(completionItem);
        }
        return completions;
    }

    private CompletionItem createCamelQuarkusDebugProfileCompletionItem() {
        CompletionItem completionQuarkusDebugProfile = new CompletionItem("Camel debug profile for Quarkus");
        completionQuarkusDebugProfile.setInsertText("<profile>\n\t<id>camel.debug</id>\n\t<activation>\n\t\t<property>\n\t\t\t<name>camel.debug</name>\n\t\t\t<value>true</value>\n\t\t</property>\n\t</activation>\n\t<dependencies>\n\t\t<dependency>\n\t\t\t<groupId>org.apache.camel.quarkus</groupId>\n\t\t\t<artifactId>camel-quarkus-debug</artifactId>\n\t\t</dependency>\n\t</dependencies>\n</profile>");
        completionQuarkusDebugProfile.setDocumentation("Adding a profile to enable Camel Debug.\nCombined with launch configuration and tasks, it allows single-click debug.\nIt requires Camel Quarkus 2.14+");
        return completionQuarkusDebugProfile;
    }

    private boolean isInsideTag(Position position, String[] lines, String enclosingTag) {
        int i;
        boolean hasEnclosingTagBefore = false;
        boolean hasEnclosingTagAfter = false;
        for (i = position.getLine(); i >= 0 && i < lines.length; --i) {
            if (lines[i].contains("<" + enclosingTag + ">")) {
                hasEnclosingTagBefore = true;
                break;
            }
            if (!lines[i].contains("</" + enclosingTag + ">")) continue;
            return false;
        }
        for (i = position.getLine(); i < lines.length; ++i) {
            if (!lines[i].contains("</" + enclosingTag + ">")) continue;
            hasEnclosingTagAfter = true;
            break;
        }
        return hasEnclosingTagBefore && hasEnclosingTagAfter;
    }
}

