/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.definition;

import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.parser.helper.CamelXmlHelper;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class DefinitionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefinitionProcessor.class);
    private ParserXMLFileHelper parserXMLFileHelper = new ParserXMLFileHelper();
    private TextDocumentItem textDocumentItem;

    public DefinitionProcessor(TextDocumentItem textDocumentItem) {
        this.textDocumentItem = textDocumentItem;
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> getDefinitions(Position position) {
        Set<PathParamURIInstance> pathParams;
        CamelURIInstance camelURIInstance;
        String camelComponentUri;
        if (this.textDocumentItem.getUri().endsWith(".xml") && (camelComponentUri = this.parserXMLFileHelper.getCamelComponentUri(this.textDocumentItem, position)) != null && (camelURIInstance = this.parserXMLFileHelper.createCamelURIInstance(this.textDocumentItem, position, camelComponentUri)) != null && "ref".equals(camelURIInstance.getComponentName()) && !(pathParams = camelURIInstance.getComponentAndPathUriElementInstance().getPathParams()).isEmpty()) {
            String refId = pathParams.iterator().next().getValue();
            return this.searchEndpointsWithId(refId);
        }
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    private CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> searchEndpointsWithId(String refId) {
        try {
            List<Node> allEndpoints = this.parserXMLFileHelper.getAllEndpoints(this.textDocumentItem);
            for (Node endpoint : allEndpoints) {
                String id = CamelXmlHelper.getSafeAttribute((Node)endpoint, (String)"id");
                if (!refId.equals(id)) continue;
                return CompletableFuture.completedFuture(Either.forLeft(Arrays.asList(this.parserXMLFileHelper.retrieveLocation(endpoint, this.textDocumentItem))));
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot compute defintions for " + this.textDocumentItem.getUri(), (Throwable)e);
        }
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }
}

