/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.catalog.diagnostic.BooleanErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.EnumErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.IntegerErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.NumberErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.ReferenceErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.UnknownErrorMsg;
import com.github.cameltooling.lsp.internal.diagnostic.DiagnosticService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ConfigurationPropertiesDiagnosticService
extends DiagnosticService {
    public ConfigurationPropertiesDiagnosticService(CompletableFuture<CamelCatalog> camelCatalog) {
        super(camelCatalog);
    }

    public Map<String, ConfigurationPropertiesValidationResult> computeCamelConfigurationPropertiesErrors(String camelText, String uri) {
        HashMap<String, ConfigurationPropertiesValidationResult> errors = new HashMap<String, ConfigurationPropertiesValidationResult>();
        if (uri.endsWith(".properties")) {
            BufferedReader bufReader = new BufferedReader(new StringReader(camelText));
            String line = null;
            int lineNumber = 0;
            try {
                while ((line = bufReader.readLine()) != null) {
                    ConfigurationPropertiesValidationResult validationResult = ((CamelCatalog)this.camelCatalog.get()).validateConfigurationProperty(line);
                    if (validationResult.hasErrors() && validationResult.getIncapable() == null) {
                        validationResult.setLineNumber(lineNumber);
                        errors.put(line, validationResult);
                    }
                    ++lineNumber;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logExceptionValidatingDocument(uri, e);
            }
            catch (IOException | ExecutionException e) {
                this.logExceptionValidatingDocument(uri, e);
            }
        }
        return errors;
    }

    public Collection<Diagnostic> converToLSPDiagnostics(Map<String, ConfigurationPropertiesValidationResult> configurationPropertiesErrors) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        for (Map.Entry<String, ConfigurationPropertiesValidationResult> errorEntry : configurationPropertiesErrors.entrySet()) {
            ConfigurationPropertiesValidationResult validationResult = errorEntry.getValue();
            String lineContentInError = errorEntry.getKey();
            List<Diagnostic> unknownParameterDiagnostics = this.computeUnknowParameters(validationResult, lineContentInError);
            lspDiagnostics.addAll(unknownParameterDiagnostics);
            List<Diagnostic> invalidEnumDiagnostics = this.computeInvalidEnumsDiagnostic(validationResult, lineContentInError);
            lspDiagnostics.addAll(invalidEnumDiagnostics);
            if (invalidEnumDiagnostics.size() + unknownParameterDiagnostics.size() >= validationResult.getNumberOfErrors()) continue;
            lspDiagnostics.add(new Diagnostic(this.computeRange(validationResult, lineContentInError, lineContentInError), this.computeErrorMessage(validationResult), DiagnosticSeverity.Error, "Apache Camel validation", null));
        }
        return lspDiagnostics;
    }

    private List<Diagnostic> computeInvalidEnumsDiagnostic(ConfigurationPropertiesValidationResult validationResult, String lineContentInError) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        Map invalidEnums = validationResult.getInvalidEnum();
        if (invalidEnums != null) {
            for (Map.Entry<String, String> entry : invalidEnums.entrySet()) {
                lspDiagnostics.add(new Diagnostic(this.computeRange(validationResult, lineContentInError, (String)entry.getKey()), new EnumErrorMsg().getErrorMessage(validationResult, entry), DiagnosticSeverity.Error, "Apache Camel validation", "camel.diagnostic.invalid.enum"));
            }
        }
        return lspDiagnostics;
    }

    private Range computeRange(ConfigurationPropertiesValidationResult validationResult, String lineContentInError, String value) {
        int endCharacter;
        int startCharacter;
        int indexOfEnum = lineContentInError.indexOf(value);
        if (indexOfEnum != -1) {
            startCharacter = indexOfEnum;
            endCharacter = indexOfEnum + value.length();
        } else {
            startCharacter = 0;
            endCharacter = lineContentInError.length();
        }
        int lineNumber = validationResult.getLineNumber();
        return new Range(new Position(lineNumber, startCharacter), new Position(lineNumber, endCharacter));
    }

    private List<Diagnostic> computeUnknowParameters(ConfigurationPropertiesValidationResult validationResult, String lineContentInError) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        Set unknownParameters = validationResult.getUnknown();
        if (unknownParameters != null) {
            for (String unknownParameter : unknownParameters) {
                int lastIndexOf = unknownParameter.lastIndexOf(46);
                String realValueOfUnknowparameter = lastIndexOf != -1 ? unknownParameter.substring(lastIndexOf + 1) : unknownParameter;
                lspDiagnostics.add(new Diagnostic(this.computeRange(validationResult, lineContentInError, realValueOfUnknowparameter), new UnknownErrorMsg().getErrorMessage(unknownParameter), DiagnosticSeverity.Error, "Apache Camel validation", "camel.diagnostic.unknown.properties"));
            }
        }
        return lspDiagnostics;
    }

    private String computeErrorMessage(ConfigurationPropertiesValidationResult validationResult) {
        StringBuilder sb = new StringBuilder();
        this.computeErrorMessage(sb, validationResult.getInvalidInteger(), new IntegerErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidNumber(), new NumberErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidBoolean(), new BooleanErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidReference(), new ReferenceErrorMsg());
        this.computeErrorMessage(sb, validationResult.getSyntaxError());
        return sb.toString();
    }
}

