/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.diagnostic.DiagnosticService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextDocumentItem;

public class ConnectedModeDiagnosticService
extends DiagnosticService {
    public ConnectedModeDiagnosticService() {
        super(null);
    }

    public Collection<? extends Diagnostic> compute(String camelText, TextDocumentItem documentItem) {
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        List<CamelEndpointDetails> endpoints = this.retrieveEndpoints(documentItem.getUri(), camelText);
        for (CamelEndpointDetails camelEndpointDetails : endpoints) {
            String endpointUri = camelEndpointDetails.getEndpointUri();
            if (endpointUri.startsWith("knative")) {
                diagnostics.add(new Diagnostic(this.computeRange(camelText, documentItem, camelEndpointDetails), "If a connection to Kubernetes with Knative installed is active, the completion will be dynamically augmented.", DiagnosticSeverity.Hint, "Apache Camel validation", null));
                continue;
            }
            if (!endpointUri.startsWith("kubernetes-")) continue;
            diagnostics.add(new Diagnostic(this.computeRange(camelText, documentItem, camelEndpointDetails), "If a connection to Kubernetes is active, the completion will be dynamically augmented.", DiagnosticSeverity.Hint, "Apache Camel validation", null));
        }
        return diagnostics;
    }
}

