/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.CamelLanguageServer;
import com.github.cameltooling.lsp.internal.diagnostic.CamelKModelineDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.ConfigurationPropertiesDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.ConnectedModeDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.EndpointDiagnosticService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;

public class DiagnosticRunner {
    private CamelLanguageServer camelLanguageServer;
    private EndpointDiagnosticService endpointDiagnosticService;
    private ConfigurationPropertiesDiagnosticService configurationPropertiesDiagnosticService;
    private CamelKModelineDiagnosticService camelKModelineDiagnosticService;
    private ConnectedModeDiagnosticService connectedModeDiagnosticService;
    private Map<String, CompletableFuture<Void>> lastTriggeredDiagnostic = new HashMap<String, CompletableFuture<Void>>();

    public DiagnosticRunner(CompletableFuture<CamelCatalog> camelCatalog, CamelLanguageServer camelLanguageServer) {
        this.camelLanguageServer = camelLanguageServer;
        this.endpointDiagnosticService = new EndpointDiagnosticService(camelCatalog);
        this.configurationPropertiesDiagnosticService = new ConfigurationPropertiesDiagnosticService(camelCatalog);
        this.camelKModelineDiagnosticService = new CamelKModelineDiagnosticService();
        this.connectedModeDiagnosticService = new ConnectedModeDiagnosticService();
    }

    public void compute(DidSaveTextDocumentParams params) {
        String camelText = this.retrieveFullText(params);
        this.computeDiagnostics(camelText, this.camelLanguageServer.getTextDocumentService().getOpenedDocument(params.getTextDocument().getUri()));
    }

    public void compute(DidChangeTextDocumentParams params) {
        String camelText = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        this.computeDiagnostics(camelText, this.camelLanguageServer.getTextDocumentService().getOpenedDocument(params.getTextDocument().getUri()));
    }

    public void compute(DidOpenTextDocumentParams params) {
        String camelText = params.getTextDocument().getText();
        this.computeDiagnostics(camelText, params.getTextDocument());
    }

    public void computeDiagnostics(String camelText, TextDocumentItem documentItem) {
        String uri = documentItem.getUri();
        CompletableFuture<Void> previousComputation = this.lastTriggeredDiagnostic.get(uri);
        if (previousComputation != null) {
            previousComputation.cancel(true);
        }
        CompletableFuture<Void> lastTriggeredComputation = CompletableFuture.runAsync(() -> {
            Map<CamelEndpointDetails, EndpointValidationResult> endpointErrors = this.endpointDiagnosticService.computeCamelEndpointErrors(camelText, uri);
            TextDocumentItem openedDocument = this.camelLanguageServer.getTextDocumentService().getOpenedDocument(uri);
            List<Diagnostic> diagnostics = this.endpointDiagnosticService.converToLSPDiagnostics(camelText, endpointErrors, openedDocument);
            Map<String, ConfigurationPropertiesValidationResult> configurationPropertiesErrors = this.configurationPropertiesDiagnosticService.computeCamelConfigurationPropertiesErrors(camelText, uri);
            diagnostics.addAll(this.configurationPropertiesDiagnosticService.converToLSPDiagnostics(configurationPropertiesErrors));
            diagnostics.addAll(this.camelKModelineDiagnosticService.compute(camelText, documentItem));
            diagnostics.addAll(this.connectedModeDiagnosticService.compute(camelText, documentItem));
            this.camelLanguageServer.getClient().publishDiagnostics(new PublishDiagnosticsParams(uri, diagnostics));
            this.lastTriggeredDiagnostic.remove(uri);
        });
        this.lastTriggeredDiagnostic.put(uri, lastTriggeredComputation);
    }

    private String retrieveFullText(DidSaveTextDocumentParams params) {
        String camelText = params.getText();
        if (camelText == null) {
            camelText = this.camelLanguageServer.getTextDocumentService().getOpenedDocument(params.getTextDocument().getUri()).getText();
        }
        return camelText;
    }

    public void clear(String uri) {
        CompletableFuture<Void> previousComputation = this.lastTriggeredDiagnostic.get(uri);
        if (previousComputation != null) {
            previousComputation.cancel(true);
        }
        this.camelLanguageServer.getClient().publishDiagnostics(new PublishDiagnosticsParams(uri, Collections.emptyList()));
    }
}

