/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.catalog.diagnostic.BooleanErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.EnumErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.IntegerErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.InvalidDurationErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.NumberErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.ReferenceErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.RequiredErrorMsg;
import com.github.cameltooling.lsp.internal.catalog.diagnostic.UnknownErrorMsg;
import com.github.cameltooling.lsp.internal.diagnostic.DiagnosticService;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;

public class EndpointDiagnosticService
extends DiagnosticService {
    public EndpointDiagnosticService(CompletableFuture<CamelCatalog> camelCatalog) {
        super(camelCatalog);
    }

    public Map<CamelEndpointDetails, EndpointValidationResult> computeCamelEndpointErrors(String camelText, String uri) {
        List<CamelEndpointDetails> endpoints = this.retrieveEndpoints(uri, camelText);
        return this.diagnoseEndpoints(uri, endpoints);
    }

    private Map<CamelEndpointDetails, EndpointValidationResult> diagnoseEndpoints(String uri, List<CamelEndpointDetails> endpoints) {
        HashMap<CamelEndpointDetails, EndpointValidationResult> endpointErrors = new HashMap<CamelEndpointDetails, EndpointValidationResult>();
        try {
            CamelCatalog camelCatalogResolved = (CamelCatalog)this.camelCatalog.get();
            for (CamelEndpointDetails camelEndpointDetails : endpoints) {
                EndpointValidationResult validateEndpointProperties = camelCatalogResolved.validateEndpointProperties(camelEndpointDetails.getEndpointUri(), false);
                if (!validateEndpointProperties.hasErrors() || !this.wasCapableToValidate(validateEndpointProperties)) continue;
                endpointErrors.put(camelEndpointDetails, validateEndpointProperties);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logExceptionValidatingDocument(uri, e);
        }
        catch (ExecutionException e) {
            this.logExceptionValidatingDocument(uri, e);
        }
        return endpointErrors;
    }

    private boolean wasCapableToValidate(EndpointValidationResult validateEndpointProperties) {
        return validateEndpointProperties.getIncapable() == null;
    }

    public List<Diagnostic> converToLSPDiagnostics(String fullCamelText, Map<CamelEndpointDetails, EndpointValidationResult> endpointErrors, TextDocumentItem textDocumentItem) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        for (Map.Entry<CamelEndpointDetails, EndpointValidationResult> endpointError : endpointErrors.entrySet()) {
            EndpointValidationResult validationResult = endpointError.getValue();
            CamelEndpointDetails camelEndpointDetails = endpointError.getKey();
            List<Diagnostic> unknownParameterDiagnostics = this.computeUnknowParameters(fullCamelText, textDocumentItem, validationResult, camelEndpointDetails);
            lspDiagnostics.addAll(unknownParameterDiagnostics);
            List<Diagnostic> invalidEnumDiagnostics = this.computeInvalidEnumsDiagnostic(fullCamelText, textDocumentItem, validationResult, camelEndpointDetails);
            lspDiagnostics.addAll(invalidEnumDiagnostics);
            if (invalidEnumDiagnostics.size() + unknownParameterDiagnostics.size() >= validationResult.getNumberOfErrors()) continue;
            lspDiagnostics.add(new Diagnostic(this.computeRange(fullCamelText, textDocumentItem, camelEndpointDetails), this.computeErrorMessage(validationResult), DiagnosticSeverity.Error, "Apache Camel validation", null));
        }
        return lspDiagnostics;
    }

    private List<Diagnostic> computeInvalidEnumsDiagnostic(String fullCamelText, TextDocumentItem textDocumentItem, EndpointValidationResult validationResult, CamelEndpointDetails camelEndpointDetails) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        Map invalidEnums = validationResult.getInvalidEnum();
        if (invalidEnums != null) {
            for (Map.Entry<String, String> entry : invalidEnums.entrySet()) {
                lspDiagnostics.add(new Diagnostic(this.computeRange(fullCamelText, textDocumentItem, camelEndpointDetails, entry), new EnumErrorMsg().getErrorMessage(validationResult, entry), DiagnosticSeverity.Error, "Apache Camel validation", "camel.diagnostic.invalid.enum"));
            }
        }
        return lspDiagnostics;
    }

    private List<Diagnostic> computeUnknowParameters(String fullCamelText, TextDocumentItem textDocumentItem, EndpointValidationResult validationResult, CamelEndpointDetails camelEndpointDetails) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        Set unknownParameters = validationResult.getUnknown();
        if (unknownParameters != null) {
            for (String unknownParameter : unknownParameters) {
                lspDiagnostics.add(new Diagnostic(this.computeRange(fullCamelText, textDocumentItem, camelEndpointDetails, unknownParameter), new UnknownErrorMsg().getErrorMessage(unknownParameter), DiagnosticSeverity.Error, "Apache Camel validation", "camel.diagnostic.unknown.properties"));
            }
        }
        return lspDiagnostics;
    }

    private Range computeRange(String fullCamelText, TextDocumentItem textDocumentItem, CamelEndpointDetails camelEndpointDetails, Map.Entry<String, String> invalidEnum) {
        int startCharacter;
        String lineContainingTheCamelURI;
        int startCharacterOfProperty;
        int startLine;
        int endLine = camelEndpointDetails.getLineNumberEnd() != null ? Integer.valueOf(camelEndpointDetails.getLineNumberEnd()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        int n = startLine = camelEndpointDetails.getLineNumber() != null ? Integer.valueOf(camelEndpointDetails.getLineNumber()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        if (startLine == endLine && (startCharacterOfProperty = (lineContainingTheCamelURI = new ParserFileHelperUtil().getLine(textDocumentItem, endLine)).indexOf(invalidEnum.getKey())) != -1 && (startCharacter = lineContainingTheCamelURI.indexOf(invalidEnum.getValue(), startCharacterOfProperty)) != -1) {
            int endCharacter = startCharacter + invalidEnum.getValue().length();
            return new Range(new Position(startLine, startCharacter), new Position(endLine, endCharacter));
        }
        return this.computeRange(fullCamelText, textDocumentItem, camelEndpointDetails);
    }

    private Range computeRange(String fullCamelText, TextDocumentItem textDocumentItem, CamelEndpointDetails camelEndpointDetails, String unknownParameter) {
        String lineContainingTheCamelURI;
        int startCharacter;
        int startLine;
        int endLine = camelEndpointDetails.getLineNumberEnd() != null ? Integer.valueOf(camelEndpointDetails.getLineNumberEnd()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        int n = startLine = camelEndpointDetails.getLineNumber() != null ? Integer.valueOf(camelEndpointDetails.getLineNumber()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        if (startLine == endLine && (startCharacter = (lineContainingTheCamelURI = new ParserFileHelperUtil().getLine(textDocumentItem, endLine)).indexOf(unknownParameter)) != -1) {
            int endCharacter = startCharacter + unknownParameter.length();
            return new Range(new Position(startLine, startCharacter), new Position(endLine, endCharacter));
        }
        return this.computeRange(fullCamelText, textDocumentItem, camelEndpointDetails);
    }

    private String computeErrorMessage(EndpointValidationResult validationResult) {
        StringBuilder sb = new StringBuilder();
        this.computeErrorMessage(sb, validationResult.getInvalidInteger(), new IntegerErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidNumber(), new NumberErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidBoolean(), new BooleanErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidReference(), new ReferenceErrorMsg());
        this.computeErrorMessage(sb, validationResult.getInvalidDuration(), new InvalidDurationErrorMsg());
        this.computeErrorMessage(sb, validationResult.getRequired(), new RequiredErrorMsg());
        this.computeErrorMessage(sb, validationResult.getSyntaxError());
        return sb.toString();
    }
}

