/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.documentsymbol;

import com.github.cameltooling.lsp.internal.documentsymbol.AbstractDocumentSymbolProcessor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSymbolJavaProcessor
extends AbstractDocumentSymbolProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSymbolJavaProcessor.class);

    public DocumentSymbolJavaProcessor(TextDocumentItem textDocumentItem) {
        super(textDocumentItem);
    }

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbolInformations() {
        try {
            JavaType parsedJavaFile = Roaster.parse((String)this.textDocumentItem.getText());
            if (parsedJavaFile instanceof JavaClassSource) {
                JavaClassSource clazz = (JavaClassSource)parsedJavaFile;
                String absolutePathOfCamelFile = new File(URI.create(this.textDocumentItem.getUri())).getAbsolutePath();
                List camelNodes = RouteBuilderParser.parseRouteBuilderTree((JavaClassSource)clazz, (String)absolutePathOfCamelFile, (boolean)true);
                ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
                RouteBuilderParser.parseRouteBuilderEndpoints((JavaClassSource)clazz, (String)"", (String)absolutePathOfCamelFile, endpoints);
                return this.createSymbolInformations(camelNodes, endpoints);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error while computing Document symbols for " + this.textDocumentItem.getUri(), (Throwable)ex);
        }
        return Collections.emptyList();
    }
}

