/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.folding;

import com.github.cameltooling.lsp.internal.catalog.util.CamelNodeDetailsUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoldingRangeProcessor {
    private static final String CHOICE_EIP_NAME = "choice";
    private static final Logger LOGGER = LoggerFactory.getLogger(FoldingRangeProcessor.class);

    public CompletableFuture<List<FoldingRange>> computeFoldingRanges(TextDocumentItem textDocumentItem) {
        String uri = textDocumentItem.getUri();
        if (uri.endsWith(".java")) {
            try {
                JavaType parsedJavaFile = Roaster.parse((String)textDocumentItem.getText());
                if (parsedJavaFile instanceof JavaClassSource) {
                    JavaClassSource clazz = (JavaClassSource)parsedJavaFile;
                    String absolutePathOfCamelFile = new File(URI.create(textDocumentItem.getUri())).getAbsolutePath();
                    List camelNodes = RouteBuilderParser.parseRouteBuilderTree((JavaClassSource)clazz, (String)absolutePathOfCamelFile, (boolean)true);
                    List<FoldingRange> foldingRanges = this.computeRouteFoldingRanges(textDocumentItem, camelNodes);
                    foldingRanges.addAll(this.computeChoiceFoldingRanges(textDocumentItem, camelNodes));
                    return CompletableFuture.completedFuture(foldingRanges);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Error while computing Folding ranges for " + textDocumentItem.getUri(), (Throwable)ex);
            }
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private Collection<FoldingRange> computeChoiceFoldingRanges(TextDocumentItem textDocumentItem, List<CamelNodeDetails> camelNodes) {
        ArrayList allNodes = new ArrayList();
        for (CamelNodeDetails camelNodeDetails : camelNodes) {
            allNodes.addAll(new CamelNodeDetailsUtils().retrieveAllChildrenOutputs(camelNodeDetails).collect(Collectors.toList()));
        }
        return allNodes.stream().filter(camelNodeDetail -> CHOICE_EIP_NAME.equals(camelNodeDetail.getName())).map(camelNode -> this.createFoldingRange(textDocumentItem, (CamelNodeDetails)camelNode)).collect(Collectors.toList());
    }

    private List<FoldingRange> computeRouteFoldingRanges(TextDocumentItem textDocumentItem, List<CamelNodeDetails> camelNodes) {
        return camelNodes.stream().map(camelNode -> this.createFoldingRange(textDocumentItem, (CamelNodeDetails)camelNode)).collect(Collectors.toList());
    }

    private FoldingRange createFoldingRange(TextDocumentItem textDocumentItem, CamelNodeDetails camelNode) {
        Range range = new CamelNodeDetailsUtils().computeRange(camelNode, textDocumentItem);
        return new FoldingRange(range.getStart().getLine(), range.getEnd().getLine());
    }
}

