/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CamelComponentSchemesCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.CamelComponentAndPathUriInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.DSLModelHelper;
import com.github.cameltooling.lsp.internal.instancemodel.JavaDSLModelHelper;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.XMLDSLModelHelper;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.w3c.dom.Node;

public class CamelURIInstance
extends CamelUriElementInstance {
    private static final List<String> PRODUCER_TYPE_POSSIBLE_NAMES = Arrays.asList("to", "interceptSendToEndpoint", "wireTap", "deadLetterChanel");
    private DSLModelHelper dslModelHelper;
    private Position startPositionInDocument;
    private Position endPositionInDocument;
    private CamelComponentAndPathUriInstance componentAndPathUriElementInstance;
    private Set<OptionParamURIInstance> optionParams = new HashSet<OptionParamURIInstance>();

    public CamelURIInstance(String uriToParse, Node node, TextDocumentItem textDocumentItem) {
        super(0, uriToParse != null ? uriToParse.length() : 0);
        this.setDocument(textDocumentItem);
        this.dslModelHelper = new XMLDSLModelHelper(node);
        this.init(uriToParse);
    }

    public CamelURIInstance(String uriToParse, String methodName, TextDocumentItem textDocumentItem) {
        super(0, uriToParse != null ? uriToParse.length() : 0);
        this.setDocument(textDocumentItem);
        this.dslModelHelper = new JavaDSLModelHelper(methodName);
        this.init(uriToParse);
    }

    public CamelURIInstance(String uriToParse, DSLModelHelper dslModelHelper, TextDocumentItem textDocumentItem) {
        super(0, uriToParse != null ? uriToParse.length() : 0);
        this.setDocument(textDocumentItem);
        this.dslModelHelper = dslModelHelper;
        this.init(uriToParse);
    }

    private void init(String uriToParse) {
        if (uriToParse != null && !uriToParse.isEmpty()) {
            int posQuestionMark = uriToParse.indexOf(63);
            this.componentAndPathUriElementInstance = posQuestionMark > 0 ? new CamelComponentAndPathUriInstance(this, uriToParse.substring(0, posQuestionMark), posQuestionMark) : new CamelComponentAndPathUriInstance(this, uriToParse, uriToParse.length());
            this.initOptionParams(uriToParse, posQuestionMark > 0 ? posQuestionMark : uriToParse.length());
        }
    }

    private void initOptionParams(String uriToParse, int posEndofPathParams) {
        if (uriToParse.length() > posEndofPathParams) {
            String parametersSeparator = this.dslModelHelper.getParametersSeparator();
            String[] allOptionParams = uriToParse.substring(posEndofPathParams + 1).split(parametersSeparator);
            int currentPosition = posEndofPathParams + 1;
            for (String optionParam : allOptionParams) {
                this.optionParams.add(new OptionParamURIInstance(this, optionParam, currentPosition, currentPosition + optionParam.length()));
                currentPosition += optionParam.length() + parametersSeparator.length();
            }
            if (uriToParse.endsWith(parametersSeparator)) {
                this.optionParams.add(new OptionParamURIInstance(this, "", currentPosition, currentPosition));
            }
        }
    }

    public Set<OptionParamURIInstance> getOptionParams() {
        return this.optionParams;
    }

    public CamelUriElementInstance getSpecificElement(int position) {
        if (this.componentAndPathUriElementInstance != null && this.componentAndPathUriElementInstance.isInRange(position)) {
            return this.componentAndPathUriElementInstance.getSpecificElement(position);
        }
        for (OptionParamURIInstance optionParamURIInstance : this.optionParams) {
            if (!optionParamURIInstance.isInRange(position)) continue;
            return optionParamURIInstance.getSpecificElement(position);
        }
        return this;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.getStartPositionInUri() <= positionInCamelUri && positionInCamelUri <= this.getEndPositionInUri()) {
            return camelCatalog.thenApply((Function)new CamelComponentSchemesCompletionsFuture(this, this.getFilter(), docItem));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private String getFilter() {
        if (this.componentAndPathUriElementInstance != null) {
            return String.format("%s:", this.componentAndPathUriElementInstance.getComponentName());
        }
        return null;
    }

    public boolean isProducer() {
        return PRODUCER_TYPE_POSSIBLE_NAMES.contains(this.dslModelHelper.getTypeDeterminingProducerConsumer());
    }

    public CamelComponentAndPathUriInstance getComponentAndPathUriElementInstance() {
        return this.componentAndPathUriElementInstance;
    }

    @Override
    public String getComponentName() {
        if (this.componentAndPathUriElementInstance != null) {
            return this.componentAndPathUriElementInstance.getComponentName();
        }
        return null;
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        return null;
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this;
    }

    public Position getStartPositionInDocument() {
        return this.startPositionInDocument;
    }

    public void setStartPositionInDocument(Position positionInDocument) {
        this.startPositionInDocument = positionInDocument;
    }

    public Position getEndPositionInDocument() {
        return this.endPositionInDocument;
    }

    public void setEndPositionInDocument(Position endPositionInDocument) {
        this.endPositionInDocument = endPositionInDocument;
    }

    public Range getAbsoluteBounds() {
        return new Range(this.startPositionInDocument, this.endPositionInDocument);
    }

    public DSLModelHelper getDslModelHelper() {
        return this.dslModelHelper;
    }
}

