/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import com.github.cameltooling.lsp.internal.kubernetes.KnativeConfigManager;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.eventing.v1beta1.EventTypeList;
import io.fabric8.knative.messaging.v1.ChannelList;
import io.fabric8.knative.messaging.v1.InMemoryChannelList;
import io.fabric8.knative.serving.v1.ServiceList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;

public class KnativeCompletionProvider {
    private static final String TYPE_EVENT = "event";
    private static final String TYPE_ENDPOINT = "endpoint";
    private static final String TYPE_CHANNEL = "channel";

    public CompletableFuture<List<CompletionItem>> get(PathParamURIInstance pathParamURIInstance) {
        Optional<String> typeParam = pathParamURIInstance.getCamelComponentAndPathUriInstance().getPathParams().stream().filter(pathParam -> pathParam.getPathParamIndex() == 0).map(PathParamURIInstance::getValue).findFirst();
        if (typeParam.isPresent()) {
            KnativeClient client = KnativeConfigManager.getInstance().getClient();
            String type = typeParam.get();
            if (TYPE_CHANNEL.equals(type)) {
                ArrayList allChannels = new ArrayList();
                allChannels.addAll(((InMemoryChannelList)client.inMemoryChannels().list()).getItems().stream().map(channel -> {
                    CompletionItem completionItem = new CompletionItem(channel.getMetadata().getName());
                    CompletionResolverUtils.applyTextEditToCompletionItem(pathParamURIInstance, completionItem);
                    return completionItem;
                }).collect(Collectors.toList()));
                allChannels.addAll(((ChannelList)client.channels().list()).getItems().stream().map(channel -> {
                    CompletionItem completionItem = new CompletionItem(channel.getMetadata().getName());
                    CompletionResolverUtils.applyTextEditToCompletionItem(pathParamURIInstance, completionItem);
                    return completionItem;
                }).collect(Collectors.toList()));
                return CompletableFuture.completedFuture(allChannels);
            }
            if (TYPE_ENDPOINT.equals(type)) {
                return CompletableFuture.completedFuture(((ServiceList)client.services().list()).getItems().stream().map(service -> {
                    CompletionItem completionItem = new CompletionItem(service.getMetadata().getName());
                    CompletionResolverUtils.applyTextEditToCompletionItem(pathParamURIInstance, completionItem);
                    return completionItem;
                }).collect(Collectors.toList()));
            }
            if (TYPE_EVENT.equals(type)) {
                return CompletableFuture.completedFuture(((EventTypeList)client.eventTypes().list()).getItems().stream().map(eventType -> {
                    CompletionItem completionItem = new CompletionItem(eventType.getMetadata().getName());
                    CompletionResolverUtils.applyTextEditToCompletionItem(pathParamURIInstance, completionItem);
                    return completionItem;
                }).collect(Collectors.toList()));
            }
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }
}

