/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CamelComponentIdsCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentPropertyKey;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;

public class CamelComponentNamePropertyInstance
implements ILineRangeDefineable {
    private String componentName;
    private CamelComponentPropertyKey camelComponentPropertyKey;

    public CamelComponentNamePropertyInstance(String componentName, CamelComponentPropertyKey camelComponentPropertyKey) {
        this.componentName = componentName;
        this.camelComponentPropertyKey = camelComponentPropertyKey;
    }

    @Override
    public int getLine() {
        return this.camelComponentPropertyKey.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.camelComponentPropertyKey.getStartPositionInLine();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.componentName.length();
    }

    public String getName() {
        return this.componentName;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        int characterPosition = position.getCharacter();
        String componentIdBeforePosition = this.componentName.substring(0, characterPosition - this.getStartPositionInLine());
        return camelCatalog.thenApply((Function)new CamelComponentIdsCompletionsFuture(this, componentIdBeforePosition));
    }

    public CompletableFuture<Hover> getHover(CompletableFuture<CamelCatalog> camelCatalog) {
        return camelCatalog.thenApply(catalog -> {
            String description;
            ComponentModel componentModel;
            String componentJSonSchema = catalog.componentJSonSchema(this.componentName);
            if (componentJSonSchema != null && (componentModel = ModelHelper.generateComponentModel(componentJSonSchema, true)) != null && (description = componentModel.getDescription()) != null) {
                return this.createHover(description);
            }
            return null;
        });
    }
}

