/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CamelComponentOptionValuesCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyKeyInstance;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelPropertyValueInstance
implements ILineRangeDefineable {
    private String camelPropertyValue;
    private CamelPropertyKeyInstance key;

    public CamelPropertyValueInstance(String camelPropertyFileValue, CamelPropertyKeyInstance key, TextDocumentItem textDocumentItem) {
        this.camelPropertyValue = camelPropertyFileValue;
        this.key = key;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog, KameletsCatalogManager kameletsCatalogManager) {
        String startFilter = this.computeStartFilter(position);
        return camelCatalog.thenApply((Function)new CamelComponentOptionValuesCompletionsFuture(this, startFilter));
    }

    private String computeStartFilter(Position position) {
        return this.camelPropertyValue.substring(0, position.getCharacter() - this.key.getEndposition() - 1);
    }

    public String getCamelPropertyFileValue() {
        return this.camelPropertyValue;
    }

    public CamelPropertyKeyInstance getKey() {
        return this.key;
    }

    @Override
    public int getLine() {
        return this.key.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.key.getEndposition() + 1;
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + (this.camelPropertyValue != null ? this.camelPropertyValue.length() : 0);
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog, KameletsCatalogManager kameletCatalogManager) {
        return CompletableFuture.completedFuture(null);
    }
}

