/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineConfigFileOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;

public class CamelKModelineConfigOption
implements ICamelKModelineOptionValue {
    private static final String PREFIX_FILE = "file:";
    private String value;
    private int startPosition;
    private int line;
    private CamelKModelineConfigFileOption configFileValue;

    public CamelKModelineConfigOption(String value, int startPosition, String documentItemUri, int line) {
        this.value = value;
        this.startPosition = startPosition;
        this.line = line;
        if (value.startsWith(PREFIX_FILE)) {
            this.configFileValue = new CamelKModelineConfigFileOption(value.substring(PREFIX_FILE.length()), startPosition + PREFIX_FILE.length(), documentItemUri, line);
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.startPosition + this.value.length();
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (position == this.startPosition) {
            CompletionItem configmap = new CompletionItem("configmap:");
            configmap.setDocumentation("Add a runtime configuration from a Configmap (syntax: configmap:name[/key], where name represents the configmap name, key optionally represents the configmap key to be filtered)");
            CompletionItem secret = new CompletionItem("secret:");
            secret.setDocumentation("Add a runtime configuration from a Secret (syntax: secret:name[/key], where name represents the secret name, key optionally represents the secret key to be filtered)");
            CompletionItem file = new CompletionItem(PREFIX_FILE);
            file.setDocumentation("Add a runtime configuration from a file (syntax: file:name, where name represents the local file path)");
            return CompletableFuture.completedFuture(Arrays.asList(configmap, secret, file));
        }
        if (this.configFileValue != null && this.configFileValue.isInRange(position)) {
            return this.configFileValue.getCompletions(position, camelCatalog);
        }
        return ICamelKModelineOptionValue.super.getCompletions(position, camelCatalog);
    }
}

