/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InsertTextFormat;

public class CamelKModelineDependencyOption
implements ICamelKModelineOptionValue {
    private String value;
    private int startPosition;
    private int line;

    public CamelKModelineDependencyOption(String value, int startPosition, int line) {
        this.value = value;
        this.startPosition = startPosition;
        this.line = line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.startPosition + (this.value != null ? this.value.length() : 0);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.getStartPositionInLine() <= position && position <= this.getEndPositionInLine()) {
            String filter = this.value != null ? this.value.substring(0, position - this.getStartPositionInLine()) : "";
            return ((CompletableFuture)((CompletableFuture)camelCatalog.thenApply(this.retrieveCamelComponentCompletionItems(filter))).thenApply(this.addMvnDependencyCompletionItem(filter))).thenApply(this.addJitpackCompletionItem(filter));
        }
        return ICamelKModelineOptionValue.super.getCompletions(position, camelCatalog);
    }

    private Function<List<CompletionItem>, List<CompletionItem>> addJitpackCompletionItem(String filter) {
        return completionItems -> {
            if (filter != null || !"".equals(filter)) {
                completionItems.add(this.createJitpackCompletionItem());
            }
            return completionItems;
        };
    }

    private CompletionItem createJitpackCompletionItem() {
        CompletionItem completionItem = new CompletionItem("jitpack:<gitProvider>.<username>:<repo>:<version>");
        completionItem.setSortText("1");
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        completionItem.setInsertText("jitpack:${1|com.github,com.gitlab,com.bitbucket,com.gitee,com.azure|}.${2:username}:${3:repo}:${4:main-SNAPSHOT}");
        CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
        return completionItem;
    }

    private Function<List<CompletionItem>, List<CompletionItem>> addMvnDependencyCompletionItem(String filter) {
        return completionItems -> {
            if (filter != null || !"".equals(filter)) {
                completionItems.add(this.createMvnCompletionItem());
            }
            return completionItems;
        };
    }

    private Function<? super CamelCatalog, ? extends List<CompletionItem>> retrieveCamelComponentCompletionItems(String filter) {
        return catalog -> catalog.findComponentNames().stream().map(componentName -> ModelHelper.generateComponentModel(catalog.componentJSonSchema(componentName), true)).filter(componentModel -> componentModel.getArtifactId() != null).map(componentModel -> {
            CompletionItem completionItem = new CompletionItem(componentModel.getArtifactId());
            completionItem.setDocumentation(componentModel.getDescription());
            CompletionResolverUtils.applyDeprecation(completionItem, componentModel.getDeprecated());
            CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
            return completionItem;
        }).filter(FilterPredicateUtils.matchesCompletionFilter(filter)).collect(Collectors.toList());
    }

    private CompletionItem createMvnCompletionItem() {
        CompletionItem completionItem = new CompletionItem("mvn:<groupId>:<artifactId>:<version>");
        completionItem.setSortText("1");
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        completionItem.setInsertText("mvn:${1:groupId}:${2:artifactId}:${3:version}");
        CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
        return completionItem;
    }

    @Override
    public CompletableFuture<Hover> getHover(int characterPosition, CompletableFuture<CamelCatalog> camelCatalog) {
        return camelCatalog.thenApply(catalog -> {
            Optional<ComponentModel> model = this.findComponentModel((CamelCatalog)catalog);
            if (model.isPresent()) {
                return this.createHover(model.get().getDescription());
            }
            return null;
        });
    }

    private Optional<ComponentModel> findComponentModel(CamelCatalog catalog) {
        return catalog.findComponentNames().stream().map(componentName -> ModelHelper.generateComponentModel(catalog.componentJSonSchema(componentName), true)).filter(componentModel -> this.value.equals(componentModel.getArtifactId())).findAny();
    }

    @Override
    public int getLine() {
        return this.line;
    }
}

