/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelKModelineLocalResourceRelatedOption
implements ICamelKModelineOptionValue {
    private static final String IDE_CONFIG_FOLDER_THEIA = ".theia";
    private static final String IDE_CONFIG_FOLDER_ECLIPSE_DESKTOP = ".settings";
    private static final String IDE_CONFIG_FOLDER_VSCODE = ".vscode";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelKModelineLocalResourceRelatedOption.class);
    private String value;
    private int startPosition;
    private String documentItemUri;
    private int line;

    protected CamelKModelineLocalResourceRelatedOption(String value, int startPosition, String documentItemUri, int line) {
        this.value = value;
        this.startPosition = startPosition;
        this.documentItemUri = documentItemUri;
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.value.length();
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    protected abstract String getPropertyName();

    protected abstract Predicate<Path> getFilter();

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        try {
            Path documentUriParentPath;
            Path documentUriPath = Paths.get(new URI(this.documentItemUri));
            if (documentUriPath != null && documentUriPath.toFile().exists() && (documentUriParentPath = documentUriPath.getParent()) != null && documentUriParentPath.toFile().exists()) {
                return CompletableFuture.completedFuture(this.retrieveCompletionItemsForPotentialFiles(documentUriPath, documentUriParentPath));
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException exception) {
            LOGGER.debug("Cannot provide completion for " + this.getPropertyName() + " parameter", (Throwable)exception);
        }
        return ICamelKModelineOptionValue.super.getCompletions(position, camelCatalog);
    }

    private List<CompletionItem> retrieveCompletionItemsForPotentialFiles(Path documentUriPath, Path documentUriParentPath) throws IOException {
        try (Stream<Path> pathStream = Files.walk(documentUriParentPath, new FileVisitOption[0]);){
            List<CompletionItem> list = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.equals(documentUriPath)).filter(this::isOutsideOfIDEConfigFolder).filter(this.getFilter()).map(documentUriParentPath::relativize).map(Path::toString).map(CompletionItem::new).map(completionItem -> {
                CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
                return completionItem;
            }).collect(Collectors.toList());
            return list;
        }
    }

    private boolean isOutsideOfIDEConfigFolder(Path path) {
        String absolutePath = path.toAbsolutePath().toString();
        return !absolutePath.contains(IDE_CONFIG_FOLDER_VSCODE) && !absolutePath.contains(IDE_CONFIG_FOLDER_ECLIPSE_DESKTOP) && !absolutePath.contains(IDE_CONFIG_FOLDER_THEIA);
    }
}

