/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.completion.traits.CamelKTraitManager;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;

public class CamelKModelineTraitDefinition
implements ICamelKModelineOptionValue {
    private String traitDefinitionName;
    private int startPosition;
    private CamelKModelineTraitOption traitOption;
    private int line;

    public CamelKModelineTraitDefinition(CamelKModelineTraitOption traitOption, String traitDefinitionName, int startPosition, int line) {
        this.traitOption = traitOption;
        this.traitDefinitionName = traitDefinitionName;
        this.startPosition = startPosition;
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.traitDefinitionName.length();
    }

    @Override
    public String getValueAsString() {
        return this.traitDefinitionName;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        String filter = this.retrieveTraitDefinitionPartBefore(position);
        return CompletableFuture.completedFuture(CamelKTraitManager.getTraitDefinitionNameCompletionItems(filter, this));
    }

    private String retrieveTraitDefinitionPartBefore(int position) {
        return this.traitDefinitionName.substring(0, position - this.getStartPositionInLine());
    }

    @Override
    public CompletableFuture<Hover> getHover(int characterPosition, CompletableFuture<CamelCatalog> camelCatalog) {
        String description = CamelKTraitManager.getDescription(this.traitDefinitionName);
        if (description != null) {
            return CompletableFuture.completedFuture(this.createHover(description));
        }
        return ICamelKModelineOptionValue.super.getHover(characterPosition, camelCatalog);
    }

    public CamelKModelineTraitOption getTraitOption() {
        return this.traitOption;
    }
}

