/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinition;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinitionProperty;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;

public class CamelKModelineTraitOption
implements ICamelKModelineOptionValue {
    private int startPosition;
    private int endPosition;
    private String optionValue;
    private CamelKModelineTraitDefinition traitDefinition;
    private CamelKModelineTraitDefinitionProperty traitProperty;
    private int line;

    public CamelKModelineTraitOption(String optionValue, int startPosition, int line) {
        this.optionValue = optionValue;
        this.startPosition = startPosition;
        this.line = line;
        this.endPosition = startPosition + optionValue.length();
        this.traitDefinition = this.createTraitDefinition(optionValue, startPosition);
        this.traitProperty = this.createTraitProperty(optionValue);
    }

    private CamelKModelineTraitDefinitionProperty createTraitProperty(String optionValue) {
        int indexOfDotSeparator = optionValue.indexOf(46);
        if (indexOfDotSeparator != -1) {
            int indexOfEqualSeparator = optionValue.indexOf(61, indexOfDotSeparator);
            int startPositionOfTraitDefintionProperty = this.getStartPositionInLine() + indexOfDotSeparator + 1;
            if (indexOfEqualSeparator != -1) {
                return new CamelKModelineTraitDefinitionProperty(this, optionValue.substring(indexOfDotSeparator + 1, indexOfEqualSeparator), startPositionOfTraitDefintionProperty, this.line);
            }
            return new CamelKModelineTraitDefinitionProperty(this, optionValue.substring(indexOfDotSeparator + 1), startPositionOfTraitDefintionProperty, this.line);
        }
        return null;
    }

    private CamelKModelineTraitDefinition createTraitDefinition(String optionValue, int startPosition) {
        int indexOfDotSeparator = optionValue.indexOf(46);
        if (indexOfDotSeparator != -1) {
            return new CamelKModelineTraitDefinition(this, optionValue.substring(0, indexOfDotSeparator), startPosition, this.line);
        }
        return new CamelKModelineTraitDefinition(this, optionValue, startPosition, this.line);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.endPosition;
    }

    @Override
    public String getValueAsString() {
        return this.optionValue;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.traitDefinition != null && this.traitDefinition.isInRange(position)) {
            return this.traitDefinition.getCompletions(position, camelCatalog);
        }
        if (this.traitProperty != null && this.traitProperty.isInRange(position)) {
            return this.traitProperty.getCompletions(position, camelCatalog);
        }
        return ICamelKModelineOptionValue.super.getCompletions(position, camelCatalog);
    }

    @Override
    public CompletableFuture<Hover> getHover(int characterPosition, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.traitDefinition != null && this.traitDefinition.isInRange(characterPosition)) {
            return this.traitDefinition.getHover(characterPosition, camelCatalog);
        }
        if (this.traitProperty != null && this.traitProperty.isInRange(characterPosition)) {
            return this.traitProperty.getHover(characterPosition, camelCatalog);
        }
        return ICamelKModelineOptionValue.super.getHover(characterPosition, camelCatalog);
    }

    public CamelKModelineTraitDefinition getTraitDefinition() {
        return this.traitDefinition;
    }

    public CamelKModelineTraitDefinitionProperty getTraitProperty() {
        return this.traitProperty;
    }
}

