/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.parser;

import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class ParserJavaFileHelper
extends ParserFileHelper {
    protected static final List<String> CAMEL_POSSIBLE_TYPES = Arrays.asList("to", "from");
    private static final char ENCLOSING_STRING_CHARACTER_FOR_JAVA = '\"';

    @Override
    public String getCamelComponentUri(String line, int characterPosition) {
        for (String methodName : CAMEL_POSSIBLE_TYPES) {
            int nextQuote;
            int methodNameOffset;
            int potentialStartOfCamelURI;
            String beforeCamelURI = methodName + "(" + this.getEnclosingStringCharacter();
            int methodPosition = line.indexOf(beforeCamelURI);
            if (methodPosition == -1 || !this.isBetween(characterPosition, potentialStartOfCamelURI = methodPosition + (methodNameOffset = methodName.length() + 2), nextQuote = line.indexOf(this.getEnclosingStringCharacter(), potentialStartOfCamelURI))) continue;
            return line.substring(potentialStartOfCamelURI, nextQuote);
        }
        return null;
    }

    protected char getEnclosingStringCharacter() {
        return '\"';
    }

    public String getCorrespondingMethodName(TextDocumentItem textDocumentItem, int line) {
        String lineString = this.parserFileHelperUtil.getLine(textDocumentItem, line);
        for (String methodName : CAMEL_POSSIBLE_TYPES) {
            if (!lineString.contains(methodName + "(" + this.getEnclosingStringCharacter())) continue;
            return methodName;
        }
        return null;
    }

    @Override
    public CamelURIInstance createCamelURIInstance(TextDocumentItem textDocumentItem, Position position, String camelComponentUri) {
        CamelURIInstance uriInstance = new CamelURIInstance(camelComponentUri, this.getCorrespondingMethodName(textDocumentItem, position.getLine()), textDocumentItem);
        int start = this.getStartCharacterInDocumentOnLinePosition(textDocumentItem, position);
        uriInstance.setStartPositionInDocument(new Position(position.getLine(), start));
        uriInstance.setEndPositionInDocument(new Position(position.getLine(), start + camelComponentUri.length()));
        return uriInstance;
    }

    private int getStartCharacterInDocumentOnLinePosition(TextDocumentItem textDocumentItem, Position position) {
        String beforeCamelURI = this.getCorrespondingMethodName(textDocumentItem, position.getLine()) + "(" + this.getEnclosingStringCharacter();
        return this.parserFileHelperUtil.getLine(textDocumentItem, position).indexOf(beforeCamelURI) + beforeCamelURI.length();
    }

    @Override
    public int getPositionInCamelURI(TextDocumentItem textDocumentItem, Position position) {
        String beforeCamelURI = this.getCorrespondingMethodName(textDocumentItem, position.getLine()) + "(" + this.getEnclosingStringCharacter();
        return position.getCharacter() - this.parserFileHelperUtil.getLine(textDocumentItem, position).indexOf(beforeCamelURI) - beforeCamelURI.length();
    }
}

