/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.settings;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.settings.JSONUtility;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeParams;

public class SettingsManager {
    public static final String CAMEL_CATALOG_VERSION = "Camel catalog version";
    public static final String TOP_LEVEL_SETTINGS_ID = "camel";
    public static final String EXTRA_COMPONENTS = "extra-components";
    public static final String CATALOG_RUNTIME_PROVIDER = "Camel catalog runtime provider";
    public static final String KAKFA_CONNECTION_URL = "Kafka Connection URL";
    private CamelTextDocumentService textDocumentService;
    private String kafkaConnectionUrl;
    private boolean mardownSupport;

    public SettingsManager(CamelTextDocumentService textDocumentService) {
        this.textDocumentService = textDocumentService;
    }

    public void apply(InitializeParams params) {
        this.applySettings(params.getInitializationOptions());
        ClientCapabilities capabilities = params.getCapabilities();
        if (capabilities != null && capabilities.getTextDocument().getCompletion().getCompletionItem().getDocumentationFormat().contains("markdown")) {
            this.mardownSupport = true;
        }
    }

    public void apply(DidChangeConfigurationParams params) {
        this.applySettings(params.getSettings());
    }

    private void applySettings(Object settings) {
        Map<?, ?> mapSettings = this.getSettings(settings);
        Map camelSetting = this.getSetting(mapSettings, TOP_LEVEL_SETTINGS_ID, Map.class);
        String camelCatalogVersion = this.getSetting(camelSetting, CAMEL_CATALOG_VERSION, String.class);
        List extraComponents = this.getSetting(camelSetting, EXTRA_COMPONENTS, List.class);
        String camelCatalogRuntimeProvider = this.getSetting(camelSetting, CATALOG_RUNTIME_PROVIDER, String.class);
        this.textDocumentService.updateCatalog(camelCatalogVersion, camelCatalogRuntimeProvider, extraComponents);
        this.kafkaConnectionUrl = this.getSetting(camelSetting, KAKFA_CONNECTION_URL, String.class);
    }

    private Map<?, ?> getSettings(Object settings) {
        Map mapSettings = new JSONUtility().toModel(settings, Map.class);
        return mapSettings == null ? Collections.emptyMap() : mapSettings;
    }

    private <T> T getSetting(Map<?, ?> settings, String key, Class<T> clazz) {
        Object bundleObject;
        if (settings != null && clazz.isInstance(bundleObject = settings.get(key))) {
            return clazz.cast(bundleObject);
        }
        return null;
    }

    public String getKafkaConnectionUrl() {
        return this.kafkaConnectionUrl;
    }

    public boolean isMardownSupport() {
        return this.mardownSupport;
    }
}

