/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.util.Random;

public final class DefaultRandomFunction
implements RandomFunction {
    private static final int POOL_SIZE = DefaultRandomFunction.processors();
    private static final Random[] POOL = new Random[POOL_SIZE];

    @Override
    public byte[] apply(int length) {
        byte[] bytes = new byte[length];
        DefaultRandomFunction.current().nextBytes(bytes);
        return bytes;
    }

    private static Random current() {
        int index = (int)Thread.currentThread().getId() % POOL_SIZE;
        if (POOL[index] == null) {
            DefaultRandomFunction.POOL[index] = RandomUtil.newSecureRandom();
        }
        return POOL[index];
    }

    private static int processors() {
        boolean min = true;
        int max = 16;
        int processors = Runtime.getRuntime().availableProcessors();
        if (processors < 1) {
            return 1;
        }
        if (processors > 16) {
            return 16;
        }
        return processors;
    }
}

