/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.logic;

import com.github.javaparser.symbolsolver.logic.ConfilictingGenericTypesException;
import com.github.javaparser.symbolsolver.logic.InferenceVariableType;
import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.ArrayType;
import com.github.javaparser.symbolsolver.model.typesystem.LambdaConstraintType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceType;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.github.javaparser.symbolsolver.model.typesystem.Wildcard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InferenceContext {
    private int nextInferenceVariableId = 0;
    private ObjectProvider objectProvider;
    private List<InferenceVariableType> inferenceVariableTypes = new ArrayList<InferenceVariableType>();
    private Map<String, InferenceVariableType> inferenceVariableTypeMap = new HashMap<String, InferenceVariableType>();

    public InferenceContext(ObjectProvider objectProvider) {
        this.objectProvider = objectProvider;
    }

    private InferenceVariableType inferenceVariableTypeForTp(TypeParameterDeclaration tp) {
        if (!this.inferenceVariableTypeMap.containsKey(tp.getName())) {
            InferenceVariableType inferenceVariableType = new InferenceVariableType(this.nextInferenceVariableId++, this.objectProvider);
            this.inferenceVariableTypes.add(inferenceVariableType);
            inferenceVariableType.setCorrespondingTp(tp);
            this.inferenceVariableTypeMap.put(tp.getName(), inferenceVariableType);
        }
        return this.inferenceVariableTypeMap.get(tp.getName());
    }

    public Type addPair(Type target, Type actual) {
        target = this.placeInferenceVariables(target);
        actual = this.placeInferenceVariables(actual);
        this.registerCorrespondance(target, actual);
        return target;
    }

    public Type addSingle(Type actual) {
        return this.placeInferenceVariables(actual);
    }

    private void registerCorrespondance(Type formalType, Type actualType) {
        if (formalType.isReferenceType() && actualType.isReferenceType()) {
            ReferenceType formalTypeAsReference = formalType.asReferenceType();
            ReferenceType actualTypeAsReference = actualType.asReferenceType();
            if (!formalTypeAsReference.getQualifiedName().equals(actualTypeAsReference.getQualifiedName())) {
                List ancestors = actualTypeAsReference.getAllAncestors();
                String formalParamTypeQName = formalTypeAsReference.getQualifiedName();
                List correspondingFormalType = ancestors.stream().filter(a -> a.getQualifiedName().equals(formalParamTypeQName)).collect(Collectors.toList());
                if (correspondingFormalType.isEmpty()) {
                    ancestors = formalTypeAsReference.getAllAncestors();
                    String actualParamTypeQname = actualTypeAsReference.getQualifiedName();
                    List correspondingActualType = ancestors.stream().filter(a -> a.getQualifiedName().equals(actualParamTypeQname)).collect(Collectors.toList());
                    if (correspondingActualType.isEmpty()) {
                        throw new ConfilictingGenericTypesException(formalType, actualType);
                    }
                    correspondingFormalType = correspondingActualType;
                }
                actualTypeAsReference = ((Type)correspondingFormalType.get(0)).asReferenceType();
            }
            if (formalTypeAsReference.getQualifiedName().equals(actualTypeAsReference.getQualifiedName()) && !formalTypeAsReference.typeParametersValues().isEmpty() && !actualTypeAsReference.isRawType()) {
                int i = 0;
                for (Type formalTypeParameter : formalTypeAsReference.typeParametersValues()) {
                    this.registerCorrespondance(formalTypeParameter, (Type)actualTypeAsReference.typeParametersValues().get(i));
                    ++i;
                }
            }
        } else if (formalType instanceof InferenceVariableType && !actualType.isPrimitive()) {
            ((InferenceVariableType)formalType).registerEquivalentType(actualType);
            if (actualType instanceof InferenceVariableType) {
                ((InferenceVariableType)actualType).registerEquivalentType(formalType);
            }
        } else if (!actualType.isNull() && !actualType.equals(formalType)) {
            if (actualType.isArray() && formalType.isArray()) {
                this.registerCorrespondance(formalType.asArrayType().getComponentType(), actualType.asArrayType().getComponentType());
            } else if (formalType.isWildcard()) {
                if (actualType instanceof InferenceVariableType && formalType.asWildcard().isBounded()) {
                    ((InferenceVariableType)actualType).registerEquivalentType(formalType.asWildcard().getBoundedType());
                    if (formalType.asWildcard().getBoundedType() instanceof InferenceVariableType) {
                        ((InferenceVariableType)formalType.asWildcard().getBoundedType()).registerEquivalentType(actualType);
                    }
                }
                if (actualType.isWildcard()) {
                    Wildcard formalWildcard = formalType.asWildcard();
                    Wildcard actualWildcard = actualType.asWildcard();
                    if (formalWildcard.isBounded() && formalWildcard.getBoundedType() instanceof InferenceVariableType) {
                        if (formalWildcard.isSuper() && actualWildcard.isSuper()) {
                            ((InferenceVariableType)formalType.asWildcard().getBoundedType()).registerEquivalentType(actualWildcard.getBoundedType());
                        } else if (formalWildcard.isExtends() && actualWildcard.isExtends()) {
                            ((InferenceVariableType)formalType.asWildcard().getBoundedType()).registerEquivalentType(actualWildcard.getBoundedType());
                        }
                    }
                }
                if (actualType.isReferenceType() && formalType.asWildcard().isBounded()) {
                    this.registerCorrespondance(formalType.asWildcard().getBoundedType(), actualType);
                }
            } else if (actualType instanceof InferenceVariableType) {
                if (formalType instanceof ReferenceType) {
                    ((InferenceVariableType)actualType).registerEquivalentType(formalType);
                } else if (formalType instanceof InferenceVariableType) {
                    ((InferenceVariableType)actualType).registerEquivalentType(formalType);
                }
            } else if (actualType.isConstraint()) {
                LambdaConstraintType constraintType = actualType.asConstraintType();
                if (constraintType.getBound() instanceof InferenceVariableType) {
                    ((InferenceVariableType)constraintType.getBound()).registerEquivalentType(formalType);
                }
            } else if (actualType.isPrimitive()) {
                this.registerCorrespondance(formalType, (Type)this.objectProvider.byName(actualType.asPrimitive().getBoxTypeQName()));
            } else {
                throw new UnsupportedOperationException(formalType.describe() + " " + actualType.describe());
            }
        }
    }

    private Type placeInferenceVariables(Type type) {
        if (type.isWildcard()) {
            if (type.asWildcard().isExtends()) {
                return Wildcard.extendsBound((Type)this.placeInferenceVariables(type.asWildcard().getBoundedType()));
            }
            if (type.asWildcard().isSuper()) {
                return Wildcard.superBound((Type)this.placeInferenceVariables(type.asWildcard().getBoundedType()));
            }
            return type;
        }
        if (type.isTypeVariable()) {
            return this.inferenceVariableTypeForTp(type.asTypeParameter());
        }
        if (type.isReferenceType()) {
            return type.asReferenceType().transformTypeParameters(tp -> this.placeInferenceVariables(tp));
        }
        if (type.isArray()) {
            return new ArrayType(this.placeInferenceVariables(type.asArrayType().getComponentType()));
        }
        if (type.isNull() || type.isPrimitive() || type.isVoid()) {
            return type;
        }
        if (type.isConstraint()) {
            return LambdaConstraintType.bound((Type)this.placeInferenceVariables(type.asConstraintType().getBound()));
        }
        if (type instanceof InferenceVariableType) {
            return type;
        }
        throw new UnsupportedOperationException(type.describe());
    }

    public Type resolve(Type type) {
        if (type instanceof InferenceVariableType) {
            InferenceVariableType inferenceVariableType = (InferenceVariableType)type;
            return inferenceVariableType.equivalentType();
        }
        if (type.isReferenceType()) {
            return type.asReferenceType().transformTypeParameters(tp -> this.resolve(tp));
        }
        if (type.isNull() || type.isPrimitive() || type.isVoid()) {
            return type;
        }
        if (type.isArray()) {
            return new ArrayType(this.resolve(type.asArrayType().getComponentType()));
        }
        if (type.isWildcard()) {
            if (type.asWildcard().isExtends()) {
                return Wildcard.extendsBound((Type)this.resolve(type.asWildcard().getBoundedType()));
            }
            if (type.asWildcard().isSuper()) {
                return Wildcard.superBound((Type)this.resolve(type.asWildcard().getBoundedType()));
            }
            return type;
        }
        throw new UnsupportedOperationException(type.describe());
    }
}

