/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.logic;

import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceType;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.github.javaparser.symbolsolver.model.typesystem.TypeVariable;
import com.github.javaparser.symbolsolver.model.typesystem.Wildcard;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class InferenceVariableType
implements Type {
    private int id;
    private TypeParameterDeclaration correspondingTp;
    private Set<Type> equivalentTypes = new HashSet<Type>();
    private ObjectProvider objectProvider;
    private Set<Type> superTypes = new HashSet<Type>();

    public String toString() {
        return "InferenceVariableType{id=" + this.id + '}';
    }

    public void setCorrespondingTp(TypeParameterDeclaration correspondingTp) {
        this.correspondingTp = correspondingTp;
    }

    public void registerEquivalentType(Type type) {
        this.equivalentTypes.add(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InferenceVariableType)) {
            return false;
        }
        InferenceVariableType that = (InferenceVariableType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public InferenceVariableType(int id, ObjectProvider objectProvider) {
        this.id = id;
        this.objectProvider = objectProvider;
    }

    public static InferenceVariableType fromWildcard(Wildcard wildcard, int id, ObjectProvider objectProvider) {
        InferenceVariableType inferenceVariableType = new InferenceVariableType(id, objectProvider);
        if (wildcard.isExtends()) {
            inferenceVariableType.superTypes.add(wildcard.getBoundedType());
        }
        if (wildcard.isSuper()) {
            inferenceVariableType.superTypes.add(wildcard.getBoundedType());
        }
        return inferenceVariableType;
    }

    public String describe() {
        return "InferenceVariable_" + this.id;
    }

    public boolean isAssignableBy(Type other) {
        throw new UnsupportedOperationException();
    }

    private Set<Type> concreteEquivalentTypesAlsoIndirectly(Set<InferenceVariableType> considered, InferenceVariableType inferenceVariableType) {
        considered.add(inferenceVariableType);
        HashSet<Type> result = new HashSet<Type>();
        result.addAll(inferenceVariableType.equivalentTypes.stream().filter(t -> !t.isTypeVariable() && !(t instanceof InferenceVariableType)).collect(Collectors.toSet()));
        inferenceVariableType.equivalentTypes.stream().filter(t -> t instanceof InferenceVariableType).forEach(t -> {
            InferenceVariableType ivt = (InferenceVariableType)t;
            if (!considered.contains(ivt)) {
                result.addAll(this.concreteEquivalentTypesAlsoIndirectly(considered, ivt));
            }
        });
        return result;
    }

    public Type equivalentType() {
        Set<Type> concreteEquivalent = this.concreteEquivalentTypesAlsoIndirectly(new HashSet<InferenceVariableType>(), this);
        if (concreteEquivalent.isEmpty()) {
            if (this.correspondingTp == null) {
                return this.objectProvider.object();
            }
            return new TypeVariable(this.correspondingTp);
        }
        if (concreteEquivalent.size() == 1) {
            return concreteEquivalent.iterator().next();
        }
        Set notTypeVariables = this.equivalentTypes.stream().filter(t -> !t.isTypeVariable() && !this.hasInferenceVariables((Type)t)).collect(Collectors.toSet());
        if (notTypeVariables.size() == 1) {
            return (Type)notTypeVariables.iterator().next();
        }
        if (notTypeVariables.size() == 0 && !this.superTypes.isEmpty()) {
            if (this.superTypes.size() == 1) {
                return this.superTypes.iterator().next();
            }
            throw new IllegalStateException("Super types are: " + this.superTypes);
        }
        throw new IllegalStateException("Equivalent types are: " + this.equivalentTypes);
    }

    private boolean hasInferenceVariables(Type type) {
        if (type instanceof InferenceVariableType) {
            return true;
        }
        if (type.isReferenceType()) {
            ReferenceType refType = type.asReferenceType();
            for (Type t : refType.typeParametersValues()) {
                if (!this.hasInferenceVariables(t)) continue;
                return true;
            }
            return false;
        }
        if (type.isWildcard()) {
            Wildcard wildcardType = type.asWildcard();
            return this.hasInferenceVariables(wildcardType.getBoundedType());
        }
        return false;
    }
}

